/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infodb.commons.utils.DirectoryScanner;

public class Config {
    private static Log log = LogFactory.getLog((String)"org.infodb.commons.utils.Config");
    private Properties props;

    public Config() {
        this.props = new Properties();
    }

    public Config(Properties prop) {
        this.props = prop;
    }

    public Config(String confPath) throws IOException {
        this.props = new Properties();
        if (!DirectoryScanner.search(confPath, false, new DirectoryScanner.Listener(){

            @Override
            public void found(File f) throws IOException {
                if (f.getName().equals("system.properties")) {
                    Properties p = new Properties();
                    p.load(new FileInputStream(f));
                    System.setProperties(p);
                } else if (f.getName().endsWith(".properties")) {
                    Config.this.props.load(new FileInputStream(f));
                }
            }
        })) {
            throw new IOException(MessageFormat.format("Invalid config directory.\r\npath={0}", confPath));
        }
    }

    public void load(String propFile) throws IOException {
        this.props.load(new FileInputStream(propFile));
    }

    public String getString(String name, String defValue) {
        String value = this.props.getProperty(name);
        if (value == null) {
            return defValue;
        }
        return value;
    }

    public int getInt(String name, int defValue) {
        String value = this.props.getProperty(name);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            return defValue;
        }
    }

    public boolean getBool(String name, boolean defValue) {
        String value = this.props.getProperty(name);
        if (value == null) {
            return defValue;
        }
        return Boolean.parseBoolean(value);
    }
}

