/*
 * Decompiled with CFR 0.152.
 */
package org.infodb.commons.utils;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.infodb.commons.utils.DirectoryScanner;

public class ClassScanner {
    private ClassLoader classLoader;
    private List<URL> urls = new ArrayList<URL>();
    private List<Item> annList = new ArrayList<Item>();

    public ClassScanner() {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        if (!(this.classLoader instanceof URLClassLoader)) {
            throw new ClassCastException("ClassLoader was not URLClassLoader.");
        }
        this.urls = Arrays.asList(((URLClassLoader)URLClassLoader.class.cast(this.classLoader)).getURLs());
    }

    public void addAnnotationListener(Class<? extends Annotation> annotation, Listener listener) {
        this.annList.add(new Item(annotation, listener));
    }

    public void scan() throws IOException {
        for (URL url : this.urls) {
            if (url.toString().endsWith(".jar")) {
                JarFile jarFile = new JarFile(URLDecoder.decode(url.getPath(), "UTF-8"));
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    String classPath;
                    Attributes mainAttrs = manifest.getMainAttributes();
                    if (mainAttrs == null || (classPath = mainAttrs.getValue(Attributes.Name.CLASS_PATH)) == null) continue;
                    StringTokenizer st = new StringTokenizer(classPath);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        URL entry = new URL(url, token);
                        if (!this.urls.contains(entry)) continue;
                        if (entry.toString().endsWith("/")) {
                            this.proceed(new File(URLDecoder.decode(entry.getPath(), "UTF-8")));
                            continue;
                        }
                        this.proceed(new JarFile(URLDecoder.decode(entry.getPath(), "UTF-8")));
                    }
                    continue;
                }
                this.proceed(jarFile);
                continue;
            }
            this.proceed(new File(URLDecoder.decode(url.getPath(), "UTF-8")));
        }
    }

    private void proceed(JarFile jarFile) {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            try {
                Class<?> clazz = Class.forName(name.substring(0, name.length() - 6).replace("/", "."), false, this.classLoader);
                this.check(clazz);
            }
            catch (NoClassDefFoundError e) {
            }
            catch (ClassNotFoundException e) {}
        }
    }

    private void proceed(File base) throws IOException {
        final int len = base.getPath().length();
        DirectoryScanner.search(base, true, new DirectoryScanner.Listener(){

            @Override
            public void found(File f) throws IOException {
                try {
                    if (!f.isFile()) {
                        return;
                    }
                    if (!f.getName().endsWith(".class")) {
                        return;
                    }
                    String path = f.getPath();
                    Class<?> clazz = Class.forName(path.substring(len + 1, path.length() - 6).replace(File.separatorChar, '.'), false, ClassScanner.this.classLoader);
                    ClassScanner.this.check(clazz);
                }
                catch (ClassFormatError ex) {
                }
                catch (ClassNotFoundException ex) {
                    throw new IOException(ex.getMessage(), ex);
                }
            }
        });
    }

    private void check(Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        for (Item item : this.annList) {
            if (clazz.getAnnotation(item.annotation) == null) continue;
            item.litener.found(clazz);
        }
    }

    class Item {
        Class<? extends Annotation> annotation;
        Listener litener;

        Item(Class<? extends Annotation> a, Listener l) {
            this.annotation = a;
            this.litener = l;
        }
    }

    public static interface Listener {
        public void found(Class<?> var1);
    }
}

