// $Id: CRequest.h,v 1.11 2003/09/17 02:57:53 ta_muto Exp $
// The class which manages the request from a browser.

#ifndef __wax_CRequest_h
#define __wax_CRequest_h

#include <common.h>
#include <collection.h>
#include <CParameterItem.h>
#include <CStackPoint.h>

namespace wax {
	class CRequest {
		xmlChar* userAgent;
		CCollection params;
		xmlDocPtr instanceData;
	public:
		CRequest();
		~CRequest();
		
		bool init();

		const xmlChar* getUserAgent() const { return userAgent; }
		const CCollection& getParams() const { return params; }
		
		CParameterItem* findParameter(const xmlChar* name, CStackPoint* point);
	private:
		CParameterItem* findParameterInternal(const xmlChar* name, CCollection* p);
		int parseParameter(char* paramString, bool isFinish = true);
		void escapeTokens(char* name, char* value);
		void escape(char* source);
		char AtoH(char c);
	} ;
}

#endif
