<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="UTF-8" />

<xsl:key name="categoryKey" match="file" use="category" />

<xsl:template match="/">
	<xsl:apply-templates select="file-list" />
</xsl:template>

<xsl:template match="file-list">
	<option value="">全て</option>
	<xsl:for-each select="file[generate-id(.) = generate-id(key('categoryKey', category)[1])]">
		<xsl:sort select="category" />
		<option value="{category}"><xsl:value-of select="category" /></option>
	</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
