// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

function vertex( mpos:M44,
                 mproj:M44,
                 offset:Float3 ) {
  position = input.pos.xyz * mpos * mproj + offset;
  normal = input.norm * mpos;
  out = input.pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
}
