// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib.shaders;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;
import flash.display3D.textures.Texture;

/**
  Gouraud Shader using texture and depth cueing
**/

class GouraudShaderUVDC extends hxsl.Shader {
  static public var id:String = "GouraudShaderUV";
  static var SRC = {
    include( 'tinylib/shaders/srcWithUV.hxsl' );
    var tuv:Float2;
    var lpow:Float;
    var zpos:Float;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3,
                     light:Float3,
                     ambient:Float,
                     diffuse:Float ) {
      out = input.pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
      var tnorm = normalize( input.norm * mpos );
      lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      tuv = input.uv;
      zpos = input.pos.z;
    }
    function fragment( tex:Texture,
                       alpha:Float,
                       dc:Float,
                       dclength:Float ) {
      var t = tex.get( tuv ) * lpow;
      var dccoeff = saturate( exp( - dc * ( zpos - dclength ) ) );
      out = [ dccoeff * t.x, dccoeff * t.y, dccoeff * t.z, alpha ];
    }
  }
  public function setShaderVariables( mp:Matrix3D,
                                      mpro:Matrix3D,
                                      vo:Vector3D,
                                      lt:Vector3D,
                                      am:Float,
                                      df:Float,
                                      texture:Texture,
                                      a:Float,
                                      d:Float,
                                      dl:Float ) {
    this.mpos = mp;
    this.mproj = mpro;
    this.offset = vo;
    this.light = lt;
    this.ambient = am;
    this.diffuse = df;
    this.tex = texture;
    this.alpha = a;
    this.dc = d;
    this.dclength = dl;
  }
}
