// --------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

package tinylib;

/**
  container class for a vertex
**/

class Vertex {
  @:isVar public var pos( get, set ):Point3D;
    public function get_pos():Point3D { return( pos ); }
    public function set_pos( p:Point3D ):Point3D {
      pos = p.clone();
      return( pos );
    }
  @:isVar public var normal( get, set ):Point3D;
    public function get_normal():Point3D { return( normal ); }
    public function set_normal( n:Point3D ):Point3D {
      normal = n.clone();
      return( normal );
    }

  // ##################################################################

  public function new( ?p:Point3D,
                       ?n:Point3D ) {
    if ( p != null ) pos = p.clone();
    if ( n != null ) normal = n.clone();
  }

  public function clone():Vertex {
    return( new Vertex( pos, normal ) );
  }

  public function clear():Void {
    pos = null;
    normal = null;
  }

  // a vertex must have position (normal vector is an optional attribute)
  public function isEmpty():Bool {
    if ( pos == null ) return( true );
    return( false );
  }

  public function addNormal( n:Point3D ):Void {
    if ( normal == null ) {
      normal = n.clone();
    } else {
      normal.add( n );
    }
  }

  public function toString():String {
    if ( normal == null ) return( pos.toString() );
    return( pos + "\n" + normal );
  }
}
