// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

/**
  main class of secondary structure analyzer for cpp
**/

class WMSecondary {
#if cpp
  static function main() {
    var stdin = Sys.stdin();
    var pdb:Pdb = new Pdb();
    while( true ) {
      try {
        var line = stdin.readLine();
        pdb.readLine( line );
      } catch( e:haxe.io.Eof ) {
        break;
      }
    }
    pdb.postProcess();
    var stdout = Sys.stdout();
    stdout.writeString( pdb.genSecondaryString() );
    stdout.writeString( "\n" );
  }
#else
  // dummy, empty main function for other cases
  static function main() {
  }
#end
}
