// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

// simple container for a control point in chain
//
// this class contains: 
//   * position of the control/interpolated point
//   * original position of control point
//   * direction of the face

import tinylib.Point3D;

/**
  WMCPoint: a control point used in drawing COILs and RIBBONs
**/

class WMCPoint {
  /**
    position of this control point
  **/
  @:isVar public var pos( get, set ):Point3D;
    /**
      getter of `pos`; this returns NOT a clone or a copy
    **/
    public function get_pos():Point3D { return( pos ); }
    /**
      setter of `pos`
    **/
    public function set_pos( p:Point3D ):Point3D {
      pos = p.clone();
      opos =  p;
      return( pos );
    }
  /**
    original position
  **/
  @:isVar public var opos( get, set ):Point3D;
    /**
      getter of `opos`
    **/
    public function get_opos():Point3D { return( opos ); }
    /**
      setter of `opos`
    **/
    public function set_opos( p:Point3D ):Point3D {
      opos = p.clone();
      return( opos );
    }
  /**
    direction of the plane (face); used only for RIBBONs

    Backbone C=O bonds can be used as this plane direction for proteins.
  **/
  @:isVar public var facedir( get, set ):Point3D;
    /**
      getter for `facedir`
    **/
    public function get_facedir():Point3D { return( facedir ); }
    /**
      setter for `facedir`
    **/
    public function set_facedir( f:Point3D ):Point3D {
      facedir = f.clone();
      return( facedir );
    }

  // #######################################################################

  /**
    Constructor.

    The position of the control point and the direction of the plane can
    be assigned by `p` and `f`, respectively.
  **/
  public function new( ?p:Point3D = null,
                       ?f:Point3D = null ) {
    if ( p != null ) pos = p;
    if ( f != null ) facedir = f;
  }

  /**
    returns a copy of this instance
  **/
  public function clone():WMCPoint {
    return( new WMCPoint( pos, facedir ) );
  }
}
