// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

/**
  Catalog of ACTION types
**/
class WMActionType {
  /**
    auto-rotation (rotate gradually)
  **/
  static public var AC_AUTOROT = 0;
  /**
    rotation (at once)
  **/
  static public var AC_ROT = 1;
  /**
    auto-translation (translate gradually)
  **/
  static public var AC_AUTOTRANS = 2;
  /**
    translation (at once)
  **/
  static public var AC_TRANS = 3;
  /**
    scale gradually
  **/
  static public var AC_AUTOSCALE = 4;
  /**
    scaling (at once)
  **/
  static public var AC_SCALE = 5;
  /**
    change camera position gradually
  **/
  static public var AC_AUTODEPTH = 6;
  /**
    change camera position at once
  **/
  static public var AC_DEPTH = 7;
  /**
    play forward
  **/
  static public var AC_PLAYFOR = 8;
  /**
    play backward
  **/
  static public var AC_PLAYBACK = 9;
  /**
    move to selected scene
  **/
  static public var AC_MOVESCENE = 10;
  /**
    foward scene
  **/
  static public var AC_FORWARDSCENE = 11;
  /**
    back scene
  **/
  static public var AC_BACKSCENE = 12;
  /**
    wait
  **/
  static public var AC_WAIT = 48;
  /**
    reset view state
  **/
  static public var AC_RESETVIEW = 49;
  /**
    reset; reserved for future use
  **/
  static public var AC_RESET = 50;
}
