// --------------------------------------------------------------------
// wm3d - A Flash Molecular Viewer
//
// Copyright (c) 2011-2013, tamanegi (tamanegi@users.sourceforge.jp)
// All rights reserved.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
// --------------------------------------------------------------------

/**
  An preregistered ACTION
**/
class WMAction {
  /**
    frame count
  **/
  @:isVar public var nframes( get, set ):Int;
    /**
      getter of `nframes`
    **/
    public function get_nframes():Int { return( nframes ); }
    /**
      setter of `nframes`
    **/
    public function set_nframes( n:Int ):Int {
      nframes = n;
      return( nframes );
    }

  /**
    type of action.
    List of actions are defined in WMActionType class
  **/
  @:isVar public var type( get, set ):Int;
    /**
      getter for `type`
    **/
    public function get_type():Int { return( type ); }
    /**
      setter for `type`
    **/
    public function set_type( t:Int ):Int {
      type = t;
      return( type );
    }

  /**
    parameter for action
  **/
  private var __params( null, null ):Map< String, String >;

  // #####################################################################
  /**
    Constructor
  **/
  public function new( ?nd:Xml = null ) {
    type = WMActionType.AC_WAIT;
    nframes = 0;
    __params = new Map< String, String >();
    readXmlElement( nd );
  }

  /**
    read attributes of ACTION element
  **/
  public function readXmlElement( ?nd:Xml = null ) {
    if ( nd == null ) return;
    if ( nd.exists( "params" ) ) setParams( nd.get( "params" ) );
    if ( nd.exists( "type" ) ) setType( nd.get( "type" ) );
    if ( nd.exists( "frame" ) ) {
      nframes = Std.parseInt( nd.get( "frame" ) );
    }
  }

  /**
    Set parameters
    parameters are specified as param:value in attribute of ACTION
  **/
  public function setParams( ?s:String ) {
    var ss:Array< String > = s.split( " " );
    for ( str in ss ) {
      var p:Array< String > = s.split( ":" );
      if ( p.length == 2 ) __params.set( p[0], p[1] );
    }
  }

  /**
    Set secondary structure type
  **/
  public function setType( ?t:String ) {
    var k = t.toUpperCase();
    var kint = Std.parseInt( k );
    if ( kint == WMActionType.AC_AUTOROT || k == "AUTOROT" ) {
      type = WMActionType.AC_AUTOROT;
    } else if ( kint == WMActionType.AC_ROT || k == "ROT" ) {
      type = WMActionType.AC_ROT;
    } else if ( kint == WMActionType.AC_AUTOTRANS || k == "AUTOTRANS" ) {
      type = WMActionType.AC_AUTOTRANS;
    } else if ( kint == WMActionType.AC_TRANS || k == "TRANS" ) {
      type = WMActionType.AC_TRANS;
    } else if ( kint == WMActionType.AC_AUTOSCALE || k == "AUTOSCALE" ) {
      type = WMActionType.AC_AUTOSCALE;
    } else if ( kint == WMActionType.AC_SCALE || k == "SCALE" ) {
      type = WMActionType.AC_SCALE;
    } else if ( kint == WMActionType.AC_AUTODEPTH || k == "AUTODEPTH" ) {
      type = WMActionType.AC_AUTODEPTH;
    } else if ( kint == WMActionType.AC_DEPTH || k == "DEPTH" ) {
      type = WMActionType.AC_DEPTH;
    } else if ( kint == WMActionType.AC_PLAYFOR || k == "PLAYFOR" ) {
      type = WMActionType.AC_PLAYFOR;
    } else if ( kint == WMActionType.AC_PLAYBACK || k == "PLAYBACK" ) {
      type = WMActionType.AC_PLAYBACK;
    } else if ( kint == WMActionType.AC_MOVESCENE || k == "MOVESCENE" ) {
      type = WMActionType.AC_MOVESCENE;
    } else if ( kint == WMActionType.AC_FORWARDSCENE || k == "FORWARDSCENE" ) {
      type = WMActionType.AC_FORWARDSCENE;
    } else if ( kint == WMActionType.AC_BACKSCENE || k == "BACKSCENE" ) {
      type = WMActionType.AC_BACKSCENE;
    } else if ( kint == WMActionType.AC_WAIT || k == "WAIT" ) {
      type = WMActionType.AC_WAIT;
    } else if ( kint == WMActionType.AC_RESETVIEW || k == "RESETVIEW" ) {
      type = WMActionType.AC_RESETVIEW;
    } else if ( kint == WMActionType.AC_RESET || k == "RESET" ) {
      type = WMActionType.AC_RESET;
    }
  }

  /**
    get parameter
  **/
  public function getParam( ?k:String = null ):String {
    if ( k == null ) return( null );
    return( __params.get( k ) );
  }
}
