// Square3D: 3-dimensional square
//
// # of vertexes: 4
// # of faces: 2
//
// UV mapping
// 0         1
// +---------+ 0
// |\        |
// | \       |
// |  \      |
// |   \     |
// |    \    |
// |     \   |
// |      \  |
// |       \ |
// |        \|
// +---------+ 1

class Square3D extends Polygon {
  public function new( ?width:Float = 1.0,
                       ?height:Float = 1.0,
                       ?back:Bool = false ) {
    super();
    var w:Float = width * 0.5;
    var h:Float = height * 0.5;
    addVertexPos( new Point3D( -w, -h, 0 ) );
    addVertexPos( new Point3D( -w,  h, 0 ) );
    addVertexPos( new Point3D(  w, -h, 0 ) );
    addVertexPos( new Point3D(  w,  h, 0 ) );
    if ( back ) {
      addVertexPos( new Point3D( -w, -h, 0 ) );
      addVertexPos( new Point3D( -w,  h, 0 ) );
      addVertexPos( new Point3D(  w, -h, 0 ) );
      addVertexPos( new Point3D(  w,  h, 0 ) );
    }
    var uv00:UVCoord = new UVCoord( 0.0, 0.0 );
    var uv01:UVCoord = new UVCoord( 1.0, 0.0 );
    var uv10:UVCoord = new UVCoord( 0.0, 1.0 );
    var uv11:UVCoord = new UVCoord( 1.0, 1.0 );
    addFace( new Face( 0, 1, 2, uv10, uv11, uv00 ) );
    addFace( new Face( 2, 1, 3, uv11, uv01, uv00 ) );
    if ( back ) {
      addFace( new Face( 4, 5, 6, uv10, uv11, uv00 ) );
      addFace( new Face( 6, 5, 7, uv11, uv01, uv00 ) );
    }
  }
}
