import flash.text.TextField;
import flash.text.TextFormat;
import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMLabel extends WMObjBase {
  static public var mysize:Float = 32.0;
  static public var defaults:WMBase
      = new WMBase( 130.0, 0x000000, 0x000000, 1.0, 0.0, 0, 0.0, 0.0,
                    0.0, 20, "2DUV" );
  static public var def_font:String = "Arial";

  public var font( __getFontName, __setFontName ):String;
  public var text( __getText, __setText ):String;
  public var pos( __getPos, __setPos ):Point3D;
  public var opos( __getOrgPos, __setOrgPos ):Point3D;

  public function new( ?r:Float = 130.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.0,
                       ?d:Float = 0.0,
                       ?sp:Float = 0.0,
                       ?gl:Float = 20.0 ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl );
    pos = null;
    opos = null;
    font = WMLabel.def_font;
    text = "";
  }

  public override function clear():Void {
    copyFrom( WMLabel.defaults );
    font = WMLabel.def_font;
    pos = null;
    opos = null;
    text = "";
    _polygon = null;
  }

  public override function loadFromXml( x:Xml ):Void {
    super.loadFromXml( x );
    if ( !x.exists( "pos" ) || !x.exists( "text" ) ) {
      trace( "pos and text attributes are required for a LABEL element." );
      return;
    }
    pos = Point3D.fromString( x.get( "pos" ) );
    opos = pos;
    text = x.get( "text" );
    if ( x.exists( "font" ) ) font = x.get( "font" );
    shader = "2DUV"; // only applicable shader
  }

  public function gen( c:Context3D ):Void {
    var tf:TextField = new TextField();
    tf.text = text;
    tf.autoSize = flash.text.TextFieldAutoSize.LEFT;
    tf.selectable = false;
    // larger font size might be better to draw smooth character
    tf.setTextFormat( new TextFormat( font, mysize, color0, true, null, null, null, flash.text.TextFormatAlign.LEFT ) );
    var aspect:Float = tf.width / tf.height;
    //_polygon = new Text3D( tf.width * scale, tf.height * scale );
    _polygon = new Text3D( aspect * radius, radius );
    _polygon.translate( pos.x, pos.y, pos.z );
    _polygon.createTextTexture( c, tf );
    _polygon.allocate( c, shader, color0, alpha );
  }

  public function __getPos():Point3D { return( pos ); }
  public function __getOrgPos():Point3D { return( opos ); }
  public function __getText():String { return( text ); }
  public function __getFontName():String { return( font ); }
  public function __setPos( p:Point3D ):Point3D {
    if ( p != null ) pos = p.clone();
    return( pos );
  }
  public function __setOrgPos( p:Point3D ):Point3D {
    if ( p != null ) opos = p.clone();
    return( opos );
  }
  public function __setText( t:String ):String {
    text = t;
    return( t );
  }
  public function __setFontName( fn:String ):String {
    font = fn;
    return( font );
  }

  public function num():Int { return(1); }
  public function sumPos():Point3D { return( pos ); }
  public function translate( p:Point3D ):Void { pos.add( p ); }
  public function absmax():Point3D {
    return( new Point3D( Math.abs( pos.x ), Math.abs( pos.y ), Math.abs( pos.z ) ) );
  }
  public function scaleCoord( scale:Float ):Void {
    pos.multiply( scale );
  }
}
