// Sphere class
//
// # of vertexes(quality=0): 6
// # of faces(triangle): 8
//
// UV mapping:
//  +-++--++--++
//  | /\2 /\4 /|
//  |/1 \/3 \/ |
//  +----------+
//  |\5 /\ 7/\ |
//  | \/6 \/ 8\|
//  +-++--++--++
//
//  (dead space exists at corners)
//
// Faces and UB position:
//   0-2-1 - #1 ( 0- 1- 2)
//   0-4-2 - #2 ( 3- 4- 5)
//   0-3-4 - #3 ( 6- 7- 8)
//   0-1-3 - #4 ( 9-10-11)
//   5-4-3 - #5 (12-13-14)
//   5-2-4 - #6 (15-16-17)
//   5-1-2 - #7 (18-19-20)
//   5-3-1 - #8 (21-22-23)

class Sphere3D_Obsolete extends Polygon {
  public function new( ?r:Float = 1.0,
                       ?quality:Int = 4 ) {
    super();
    var rsq:Float = r * Math.sqrt( 0.5 );

    // register vertexes
    var v:Array< Point3D > = new Array< Point3D >();
    v.push( new Point3D( 0,  r, 0 ) );      // 0
    v.push( new Point3D( -rsq, 0,  rsq ) ); // 1
    v.push( new Point3D(  rsq, 0,  rsq ) ); // 2
    v.push( new Point3D( -rsq, 0, -rsq ) ); // 3
    v.push( new Point3D(  rsq, 0, -rsq ) ); // 4
    v.push( new Point3D( 0, -r, 0 ) );      // 5
    for ( i in [ 0, 2, 1, 0, 4, 2, 0, 3, 4, 0, 1, 3,
                 5, 4, 3, 5, 2, 4, 5, 1, 2, 5, 3, 1 ] ) {
      addVertexPos( v[i] );
    }

    var uv00:UVCoord = new UVCoord( 0.2, 0.0 );
    var uv01:UVCoord = new UVCoord( 0.6, 0.0 );
    var uv02:UVCoord = new UVCoord( 1.0, 0.0 );
    var uv10:UVCoord = new UVCoord( 0.0, 0.5 );
    var uv11:UVCoord = new UVCoord( 0.4, 0.5 );
    var uv12:UVCoord = new UVCoord( 0.8, 0.5 );
    var uv20:UVCoord = new UVCoord( 0.2, 1.0 );
    var uv21:UVCoord = new UVCoord( 0.6, 1.0 );
    var uv22:UVCoord = new UVCoord( 1.0, 1.0 );

    addFaceRecursively( quality, new Face(  0,  1,  2, uv00, uv10, uv11 ), true, r );
    addFaceRecursively( quality, new Face(  3,  4,  5, uv10, uv01, uv00 ), true, r );
    addFaceRecursively( quality, new Face(  6,  7,  8, uv11, uv12, uv01 ), true, r );
    addFaceRecursively( quality, new Face(  9, 10, 11, uv01, uv12, uv02 ), true, r );
    addFaceRecursively( quality, new Face( 12, 13, 14, uv10, uv11, uv20 ), true, r );
    addFaceRecursively( quality, new Face( 15, 16, 17, uv11, uv20, uv21 ), true, r );
    addFaceRecursively( quality, new Face( 18, 19, 20, uv11, uv12, uv21 ), true, r );
    addFaceRecursively( quality, new Face( 21, 22, 23, uv12, uv21, uv22 ), true, r );
  }

  public override function addVertexNormals():Void {
    for ( vert in verts ) {
      var v:Point3D = Point3D.getSub( vert.pos, origin ).multiply( -1.0 );
      v.normalize();
      vert.normal = v;
    }
  }

  public function addFaceRecursively( q:Int,
                                      f:Face,
                                      ?c:Bool = false,
                                      ?r:Float = 0.0 ):Void {
    var source:Array< Face > = new Array< Face >();
    var derived:Array< Face > = new Array< Face >();
    source.push( f );
    for ( i in 1 ... q ) {
      derived = [];
      for ( face in source ) {
        var nv:Point3D = Point3D.getMiddle( verts[face.ids.j].pos,
                                            verts[face.ids.k].pos, c, r );
        var index:Int = addVertexPos( nv ) - 1;
        var newuv:UVCoord = UVCoord.getMiddle( face.uv1, face.uv2 );
        derived.push( new Face( index, face.ids.i, face.ids.j,
                                newuv, face.uv2, face.uv0 ) );
        derived.push( new Face( index, face.ids.k, face.ids.i,
                                newuv, face.uv0, face.uv1 ) );
      }
      source = [];
      for ( face in derived ) source.push( face );
    }
    for ( face in source ) addFace( face );
  }
}
