import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMRibbon extends WMObjBase {
  static public var defaultsRibbon:WMBase
      = new WMBase( 8.0, 0xFF0000, 0xFF0000, 1.0, 0.0, 0, 0.3, 0.7,
                    0.8, 10, "Phong" );
  static public var defaultsCoil:WMBase
      = new WMBase( 3.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 0.7,
                    0.8, 10, "Gouraud" );
  public var isRibbon( __getIsRibbon, __setIsRibbon ):Bool;

  public var initXML( __getInitXML, __setInitXML ):Int;
  public var lastXML( __getLastXML, __setLastXML ):Int;
  public var init( __getInit, __setInit ):Int;
  public var last( __getLast, __setLast ):Int;

  public function new( ?i:Bool = false,
                       ?r:Float = 1.0,
                       ?c0:Int = 0x00FF00,
                       ?c1:Int = 0x00FF00,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.43,
                       ?d:Float = 0.7,
                       ?sp:Float = 0.6,
                       ?gl:Float = 20.0 ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl );
    isRibbon = i;
    initXML = lastXML = -1;
    init = last = -1;
  }

  public function clone():WMRibbon {
    var ret:WMRibbon = new WMRibbon( isRibbon, radius, color0, color1, alpha, offset, quality, ambient, diffuse, specular, gloss );
    ret.init = init;
    ret.initXML = initXML;
    ret.last = last;
    ret.lastXML = lastXML;
    return( ret );
  }

  public override function clear():Void {
    if ( isRibbon ) {
      copyFrom( WMRibbon.defaultsRibbon );
    } else {
      copyFrom( WMRibbon.defaultsCoil );
    }
    _polygon = null;
    initXML = lastXML = -1;
  }

  private override function __myLoadFromXml( x:Xml ):Void {
    if ( !x.exists( "init" ) || !x.exists( "last" ) ) {
      trace( "init and last attributes are required for a RIBBON or COIL element" );
      return;
    }
    initXML = Std.parseInt( x.get( "init" ) );
    lastXML = Std.parseInt( x.get( "last" ) );
  }

  public function gen( c:Context3D,
                       chain:SmoothChain ):Void {
    if ( isRibbon ) {
      _polygon = chain.genRibbon( WMBase.getRelative( radius ),
                                  init, last + 1 );
    } else {
      _polygon = chain.genCoil( WMBase.getRelative( radius ), quality,
                                init, last + 1 );
    }
    _polygon.allocate( c, shader, color0, alpha );
  }

  public function __getIsRibbon():Bool { return( isRibbon ); }
  public function __getInitXML():Int { return( initXML ); }
  public function __getLastXML():Int { return( lastXML ); }
  public function __getInit():Int { return( init ); }
  public function __getLast():Int { return( last ); }
  public function __setIsRibbon( i:Bool ):Bool {
    isRibbon = i;
    return( isRibbon );
  }
  public function __setInitXML( n:Int ):Int {
    initXML = n;
    return( initXML );
  }
  public function __setLastXML( n:Int ):Int {
    lastXML = n;
    return( lastXML );
  }
  public function __setInit( n:Int ):Int {
    init = n;
    return( init );
  }
  public function __setLast( n:Int ):Int {
    last = n;
    return( last );
  }
}
