// base class for objects in Watermelon

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

import flash.display3D.Context3D;

import flash.geom.Vector3D;
import flash.geom.Matrix3D;

class WMObjBase extends WMBase {
  static public var defaults:WMBase
      = new WMBase( 0.0, 0x000000, 0x000000, 1.0, 0.0, 0, 0.3, 0.5,
                    0.2, 20.0, "Phong" );
  public var _polygon( get, null ):Dynamic;

  public function new( ?r:Float = 0.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 0.5,
                       ?sp:Float = 0.2,
                       ?gl:Float = 20.0 ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl );
  }

  public override function clear():Void {
    copyFrom( WMObjBase.defaults );
    _polygon = null;
  }

  public override function loadFromXml( x:Xml ):Void {
    clear();
    super.loadFromXml( x );
  }

  public function draw( c:Context3D,
                        mpos:Matrix3D,
                        proj:Matrix3D,
                        voffset:Vector3D,
                        ?light:Vector3D = null,
                        ?cpos:Vector3D = null ):Void {
    _polygon.draw( c, mpos, proj, voffset, light, cpos );
  }

  public function get():Dynamic { return( _polygon ); }
}
