#ifndef _COORDINATE_BASE_
#define _COORDINATE_BASE_

class Vector2D;
class Vector3D;
class cellIndex;
class cellPair;

class Vector2D {
  private:
  public:
    double x, y;

    Vector2D();
    Vector2D( const double &rx,
              const double &ry );
    Vector2D( const Vector2D &v );
    void clear();
    Vector2D operator + ( const Vector2D &v ) const;
    Vector2D operator + ( const double &v ) const;
    Vector2D operator - ( const Vector2D &v ) const;
    Vector2D operator - ( const double &v ) const;
    Vector2D operator * ( const double &v ) const;
    double operator * ( const Vector2D &v ) const; // 内積
    Vector2D operator += ( const Vector2D &v );
    Vector2D operator -= ( const Vector2D &v );
    Vector2D operator -= ( const double &v );
    Vector2D operator *= ( const double &v );
    Vector2D operator / ( const double &v ) const;
    friend std::ostream& operator << ( std::ostream &out,
                                       const Vector2D &v );
    friend std::istream& operator >> ( std::istream &in,
                                       Vector2D &v );
    double volume() const; // 周期境界の時にも使うので
    double sum() const;
    double area() const;
    double sqabs() const;
    double sqabs( const Vector2D &box );
    void normalize();
    double minabsval() const;
    double maxabsval() const;
    void unroll( const Vector2D &box );
    void unrollf( const Vector2D &box );
    cellIndex numCell( const double &cutoff,
                       const double &margin ) const;
    cellIndex numCell( const Vector2D &cutoff,
                       const double &margin ) const;
    cellIndex whichCell( const Vector2D &box,
                         const cellIndex &syssize ) const;
    void assignRand();
    bool is_zero() const;
};

class Vector3D { // 継承させると混乱しそうなので独立
  private:
  public:
    double x, y, z;

    Vector3D();
    Vector3D( const double &rx,
              const double &ry,
              const double &rz );
    Vector3D( const Vector3D &v );
    void clear();
    Vector3D operator + ( const Vector3D &v ) const;
    Vector3D operator + ( const double &v ) const;
    Vector3D operator - ( const Vector3D &v ) const;
    Vector3D operator - ( const double &v ) const;
    Vector3D operator * ( const double &v ) const;
    double operator * ( const Vector3D &v ) const; // 内積
    Vector3D operator += ( const Vector3D &v );
    Vector3D operator -= ( const Vector3D &v );
    Vector3D operator -= ( const double &v );
    Vector3D operator *= ( const double &v );
    Vector3D operator / ( const double &v ) const;
    friend std::ostream& operator << ( std::ostream &out,
                                       const Vector3D &v );
    friend std::istream& operator >> ( std::istream &in,
                                       Vector3D &v );
    double dotProduct( const Vector3D &v ) const;
    Vector3D vectorProduct( const Vector3D &v ) const;
    double volume() const; // 周期境界の時にも使うので
    double sum() const;
    double sqabs() const;
    double sqabs( const Vector3D &box );
    void normalize();
    double minabsval() const;
    double maxabsval() const;
    void unroll( const Vector3D &box );
    void unrollf( const Vector3D &box );
    cellIndex numCell( const double &cutoff,
                       const double &margin ) const;
    cellIndex numCell( const Vector3D &cutoff,
                       const double &margin ) const;
    cellIndex whichCell( const Vector3D &box,
                         const cellIndex &syssize ) const;
    void assignRand();
    bool is_zero() const;
};

class cellIndex { // 面倒なのでこれは自動的に 3 次元
  private:
  public:
    int i, j, k;

    cellIndex();
    cellIndex( const cellIndex &c );
    cellIndex( const int &ci,
               const int &cj,
               const int &ck );
    void clear();

    cellIndex operator + ( const cellIndex &c ) const;
    cellIndex operator - ( const cellIndex &c ) const;
    cellIndex operator += ( const cellIndex &c );
    cellIndex operator -= ( const cellIndex &c );
    cellIndex within( const cellIndex &c ) const;
    bool isAdjacent( const cellIndex &c, // size は各方向の大きさ
                     const cellIndex &size ) const;
    void unroll( const cellIndex &size );
    bool operator < ( const cellIndex &c ) const;
    bool operator > ( const cellIndex &c ) const;
    bool operator == ( const cellIndex &c ) const;
    bool operator != ( const cellIndex &c ) const;
    friend std::ostream& operator << ( std::ostream &out,
                                       const cellIndex &c );
    friend std::istream& operator >> ( std::istream &in,
                                       cellIndex &c );
};

class cellPair {
  private:
  public:
    cellIndex ci, cj;

    cellPair();
    cellPair( const cellIndex &pci,
              const cellIndex &pcj );
    void clear();
    void set( const cellIndex &pci,
              const cellIndex &pcj );
    void sort();
    bool operator < ( const cellPair &pc ) const;
    bool operator > ( const cellPair &pc ) const;
    bool operator == ( const cellPair &pc ) const;
};

#endif
