class PhongShaderUV extends format.hxsl.Shader {
  static public var id:String = "PhongShaderUV";
  static var SRC = {
    var input : {
      pos:Float3,
      norm:Float3,
      uv:Float2,
    }
    var tuv:Float2;
    var position:Float3;
    var normal:Float3;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3 ) {
      position = pos * mpos * mproj + offset;
      normal = norm * mpos;
      tuv = uv;
      out = pos.xyzw * mpos * mproj + [ offset.x, offset.y, offset.z, 0 ];
    }
    function fragment( tex:Texture,
                       light:Float3,
                       cpos:Float3,
                       ambient:Float,
                       diffuse:Float,
                       specular:Float,
                       gloss:Float,
                       alpha:Float ) {
      var tnorm = normalize( normal );
      var lpow = diffuse * max( 0, dot( light, tnorm ) ) + ambient;
      // specular using half vector
      var view = normalize( sub( cpos, position ));
      var half = normalize( add( light, view ));
      var spow = specular * pow( max( 0, dot( half, tnorm ) ), gloss );
      var t = tex.get( tuv ) * lpow + spow;
      out = [ t.x, t.y, t.z, alpha ];
    }
  };
}
