// simple container class for vertex ids
class TriFaceIDs {
  public var i:UInt;
  public var j:UInt;
  public var k:UInt;

  public function new( ?a:UInt,
                       ?b:UInt,
                       ?c:UInt ) {
    clear();
    if ( a != null ) i = a;
    if ( b != null ) j = b;
    if ( c != null ) k = c;
  }

  public function clear():Void {
    i = j = k = 0;
  }

  public function clone():TriFaceIDs {
    return( new TriFaceIDs( i, j, k ) );
  }

  // simple check of ids
  public function isValid():Bool {
    if ( i == j || i == k || j == k ) return( false );
    return( true );
  }

  public function toString():String {
    return( "[ " + i + " " + j + " " + k + " ]" );
  }
}
