class SimpleShader extends format.hxsl.Shader {
  static public var id:String = "SimpleShader";
  static var SRC = {
    var input : {
      pos:Float3,
      col:Float3,
    };
    var color:Float3;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3 ) {
      out = pos.xyzw * mpos * mproj + offset.xyzz;
      color = col;
    }
    function fragment( alpha:Float ) {
      out = [ color.x, color.y, color.z, alpha ];
    }
  };
}
