class GouraudShader extends format.hxsl.Shader {
  static public var id:String = "GouraudShader";
  static var SRC = {
    var input : {
      pos:Float3,
      norm:Float3,
    };
    var color:Float3;
    function vertex( mpos:M44,
                     mproj:M44,
                     offset:Float3,
                     light:Float3,
                     ambient:Float,
                     diffuse:Float,
                     col:Float3 ) {
      out = pos.xyzw * mpos * mproj + offset.xyzz;
      var tnorm = normalize( norm * mpos );
      var lpow = diffuse * max( 0, dot( light, tnorm )) + ambient;
      color = col * lpow;
    }
    function fragment( alpha:Float ) {
      out = [ color.x, color.y, color.z, alpha ];
    }
  }
}
