import flash.display3D.Context3D;

import flash.xml.XML;
import flash.xml.XMLList;
import flash.xml.XMLParser;

class WMBond extends WMObjBase {
  static public var defaults:WMBase
      = new WMBase( 1.0, 0x00FF00, 0x00FF00, 1.0, 0.0, 0, 0.3, 1.0,
                    0.6, 20, "Gouraud" );
  static public var def_round:Bool = false;
  static public var def_exclude:Bool = false;
  public var rounded( __getRounded, __setRounded ):Bool;
  public var exclude( __getExclude, __setExclude ):Bool;

  public var pos0( __getPos0, __setPos0 ):Point3D;
  public var pos1( __getPos1, __setPos1 ):Point3D;
  public var opos0( __getOrgPos0, __setOrgPos0 ):Point3D;
  public var opos1( __getOrgPos1, __setOrgPos1 ):Point3D;

  public function new( ?r:Float = 1.0,
                       ?c0:Int = 0x00FF00,
                       ?c1:Int = 0x00FF00,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 1.0,
                       ?sp:Float = 0.6,
                       ?gl:Float = 20.0 ) {
    super( r, c0, c1, a, o, q, ag, d, sp, gl );
    rounded = false;
    exclude = false;
    pos0 = null;
    pos1 = null;
    opos0 = null;
    opos1 = null;
  }

  public override function clear():Void {
    copyFrom( WMBond.defaults );
    pos0 = null;
    pos1 = null;
    opos0 = null;
    opos1 = null;
    rounded = WMBond.def_round;
    exclude = WMBond.def_exclude;
    _polygon = null;
  }

  private override function __myLoadFromXml( x:Xml ):Void {
    if ( !x.exists( "pos0" ) || !x.exists( "pos1" ) ) {
      trace( "pos0 and pos1 attributes are required for a BOND element." );
      return;
    }
    pos0 = Point3D.fromString( x.get( "pos0" ) );
    pos1 = Point3D.fromString( x.get( "pos1" ) );
    opos0 = pos0;
    opos1 = pos1;
    if ( x.exists( "rounded" ) ) {
      rounded = ( Std.parseInt( x.get( "rounded" ) ) > 0 );
    }
    if ( x.exists( "round" ) ) {
      rounded = ( Std.parseInt( x.get( "round" ) ) > 0 );
    }
    if ( x.exists( "exc" ) ) {
      exclude = ( Std.parseInt( x.get( "exc" ) ) > 0 );
    }
  }

  public function gen( c:Context3D ):Void {
    var vec:Point3D = Point3D.getSub( pos1, pos0 );
    var norm:Float = vec.norm() - WMBase.getRelative( offset );
    if ( rounded ) {
      _polygon = new RoundedCylinder( WMBase.getRelative( radius ),
                                      norm, quality );
    } else {
      _polygon = new Cylinder( WMBase.getRelative( radius ),
                               norm, quality, exclude, exclude );
    }
    if ( color0 != color1 ) {
      if ( shader == "Gouraud" ) shader = "GouraudUV";
      if ( shader == "Phong" ) shader = "PhongUV";
    }
    _polygon.lookAt( vec );
    _polygon.translateByVec( Point3D.getMiddle( pos0, pos1 ) );
    _polygon.allocate( c, shader, color0, alpha );
    if ( color0 != color1 ) {
      _polygon.createDoubleColoredTexture( c, color0, color1 );
    }
  }

  public function __getRounded():Bool { return( rounded ); }
  public function __getExclude():Bool { return( exclude ); }
  public function __getPos0():Point3D { return( pos0 ); }
  public function __getPos1():Point3D { return( pos1 ); }
  public function __getOrgPos0():Point3D { return( opos0 ); }
  public function __getOrgPos1():Point3D { return( opos1 ); }
  public function __setRounded( r:Bool ):Bool {
    rounded = r;
    return( rounded );
  }
  public function __setExclude( e:Bool ):Bool {
    exclude = e;
    return( exclude );
  }
  public function __setPos0( p:Point3D ) {
    if ( p != null ) pos0 = p.clone();
    return( pos0 );
  }
  public function __setPos1( p:Point3D ) {
    if ( p != null ) pos1 = p.clone();
    return( pos1 );
  }
  public function __setOrgPos0( p:Point3D ) {
    if ( p != null ) opos0 = p.clone();
    return( opos0 );
  }
  public function __setOrgPos1( p:Point3D ) {
    if ( p != null ) opos1 = p.clone();
    return( opos1 );
  }
}
