import flash.display.Stage;

class WMBase {
  static private var scaleBase:Float = 0.0;
  static private var characteristicSize:Float = 0.005;

  static public function setScaleBase( st:Stage ):Void {
    scaleBase = Math.min( st.stageWidth, st.stageHeight );
    scaleBase *= characteristicSize;
  }

  static public function getRelative( r:Float ):Float {
    // if not initialized, use width and height of root stage
    if ( scaleBase == 0.0 ) setScaleBase( flash.Lib.current.stage );
    return( r * scaleBase );
  }

  public var radius( __getRadius, __setRadius ):Float;
  public var color0( __getColor0, __setColor0 ):Int;
  public var color1( __getColor1, __setColor1 ):Int;
  public var alpha( __getAlpha, __setAlpha ):Float;
  public var offset( __getOffset, __setOffset ):Float;
  public var quality( __getQuality, __setQuality ):Int;

  public var ambient( __getAmbient, __setAmbient ):Float;
  public var diffuse( __getDiffuse, __setDiffuse ):Float;
  public var specular( __getSpecular, __setSpecular ):Float;
  public var gloss( __getGloss, __setGloss ):Float;
  public var shader( __getShaderName, __setShaderName ):String;

  public function new( ?r:Float = 0.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 0.5,
                       ?sp:Float = 0.2,
                       ?gl:Float = 20.0,
                       ?sh:String = "Phong" ):Void {
    set( r, c0, c1, a, o, q, ag, d, sp, gl, sh );
  }

  public function set( ?r:Float = 0.0,
                       ?c0:Int = 0x000000,
                       ?c1:Int = 0x000000,
                       ?a:Float = 1.0,
                       ?o:Float = 0.0,
                       ?q:Int = 0,
                       ?ag:Float = 0.3,
                       ?d:Float = 0.5,
                       ?sp:Float = 0.2,
                       ?gl:Float = 20.0,
                       ?sh:String = "Phong" ):Void {
    radius = r;
    color0 = c0;
    color1 = c1;
    alpha = a;
    offset = o;
    quality = q;
    ambient = ag;
    diffuse = d;
    specular = sp;
    gloss = gl;
    shader = sh;
  }

  public function clear():Void {
    radius = 0.0;
    color0 = 0x000000;
    color1 = 0x000000;
    alpha = 1.0;
    offset = 0.0;
    quality = 0;
    ambient = 0.3;
    diffuse = 0.5;
    specular = 0.2;
    gloss = 20.0;
    shader = "Phong";
  }

  public function copyFrom( d:Dynamic ):Void {
    radius = d.radius;
    color0 = d.color0;
    color1 = d.color1;
    alpha = d.alpha;
    offset = d.offset;
    quality = d.quality;
    ambient = d.ambient;
    diffuse = d.diffuse;
    specular = d.specular;
    gloss = d.gloss;
    shader = d.shader;
  }

  public function loadFromXml( x:Xml ):Void {
    // radius: r, w, radius, width
    if ( x.exists( "width" ) ) radius = Std.parseFloat( x.get( "width" ) );
    if ( x.exists( "w" ) ) radius = Std.parseFloat( x.get( "w" ) );
    if ( x.exists( "radius" ) ) radius = Std.parseFloat( x.get( "radius" ) );
    if ( x.exists( "r" ) ) radius = Std.parseFloat( x.get( "r" ) );
    // color: c, color
    if ( x.exists( "color" ) ) {
      color0 = color1 = Std.parseInt( x.get( "color" ) );
    }
    if ( x.exists( "c" ) ) {
      color0 = color1 = Std.parseInt( x.get( "c" ) );
    }
    // color0: c0, col0, color0
    if ( x.exists( "c0" ) ) color0 = Std.parseInt( x.get( "c0" ) );
    if ( x.exists( "col0" ) ) color0 = Std.parseInt( x.get( "col0" ) );
    if ( x.exists( "color0" ) ) color0 = Std.parseInt( x.get( "color0" ) );
    // color1: c1, col1, color1
    if ( x.exists( "c1" ) ) color1 = Std.parseInt( x.get( "c1" ) );
    if ( x.exists( "col1" ) ) color1 = Std.parseInt( x.get( "col1" ) );
    if ( x.exists( "color1" ) ) color1 = Std.parseInt( x.get( "color1" ) );
    // alpha: a, alpha
    if ( x.exists( "alpha" ) ) alpha = Std.parseFloat( x.get( "alpha" ) );
    if ( x.exists( "a" ) ) alpha = Std.parseFloat( x.get( "a" ) );
    // offset: o, offset
    if ( x.exists( "offset" ) ) offset = Std.parseFloat( x.get( "offset" ) );
    if ( x.exists( "o" ) ) offset = Std.parseFloat( x.get( "o" ) );
    // quality: q, quality
    if ( x.exists( "q" ) ) quality = Std.parseInt( x.get( "q" ) );
    if ( x.exists( "qua" ) ) quality = Std.parseInt( x.get( "qua" ) );
    if ( x.exists( "quality" ) ) quality = Std.parseInt( x.get( "quality" ) );
    // ambient: am, amb, ambient
    if ( x.exists( "am" ) ) ambient = Std.parseFloat( x.get( "am" ) );
    if ( x.exists( "amb" ) ) ambient = Std.parseFloat( x.get( "amb" ) );
    if ( x.exists( "ambient" ) ) ambient = Std.parseFloat( x.get( "ambient" ) );
    // diffuse: d, dif, diffuse
    if ( x.exists( "d" ) ) diffuse = Std.parseFloat( x.get( "d" ) );
    if ( x.exists( "dif" ) ) diffuse = Std.parseFloat( x.get( "dif" ) );
    if ( x.exists( "diffuse" ) ) diffuse = Std.parseFloat( x.get( "diffuse" ) );
    // specular: s, spe, specular
    if ( x.exists( "s" ) ) specular = Std.parseFloat( x.get( "s" ) );
    if ( x.exists( "spe" ) ) specular = Std.parseFloat( x.get( "spe" ) );
    if ( x.exists( "specular" ) ) specular = Std.parseFloat( x.get( "specular" ) );
    // gloss: g, gloss
    if ( x.exists( "g" ) ) gloss = Std.parseFloat( x.get( "g" ) );
    if ( x.exists( "gloss" ) ) gloss = Std.parseFloat( x.get( "gloss" ) );
    // shader: shade, shader, shading
    if ( x.exists( "shade" ) || x.exists( "shader" ) || x.exists( "shading" ) ) {
      var str:String = "";
      if ( x.exists( "shade" ) ) str = x.get( "shade" );
      if ( x.exists( "shader" ) ) str = x.get( "shader" );
      if ( x.exists( "shading" ) ) str = x.get( "shading" );
      if ( str.toLowerCase() == "simple" ) {
        shader = "Simple";
      } else if ( str.toLowerCase() == "gouraud" ) {
        shader = "Gouraud";
      } else if ( str.toLowerCase() == "phong" ) {
        shader = "Phong";
      }
    }
    __myLoadFromXml( x );
  }

  // empty function to be overrided in extended classes
  private function __myLoadFromXml( x:Xml ):Void {}

  // getters and setters
  public function __getRadius():Float { return( radius ); }
  public function __getColor0():Int { return( color0 ); }
  public function __getColor1():Int { return( color1 ); }
  public function __getAlpha():Float { return( alpha ); }
  public function __getOffset():Float { return( offset ); }
  public function __getQuality():Int { return( quality ); }
  public function __getAmbient():Float { return( ambient ); }
  public function __getDiffuse():Float { return( diffuse ); }
  public function __getSpecular():Float { return( specular ); }
  public function __getGloss():Float { return( gloss ); }
  public function __getShaderName():String { return( shader ); }
  public function __setRadius( r:Float ):Float { radius = r; return( radius ); }
  public function __setColor0( c:Int ):Int { color0 = c; return( color0 ); }
  public function __setColor1( c:Int ):Int { color1 = c; return( color1 ); }
  public function __setAlpha( a:Float ):Float { alpha = a; return( alpha ); }
  public function __setOffset( o:Float ):Float { offset = o; return( offset ); }
  public function __setQuality( q:Int ):Int { quality = q; return( quality ); }
  public function __setAmbient( a:Float ):Float { ambient = a; return( ambient ); }
  public function __setDiffuse( d:Float ):Float { diffuse = d; return( diffuse ); }
  public function __setSpecular( s:Float ):Float { specular = s; return( specular ); }
  public function __setGloss( g:Float ):Float { gloss = g; return( gloss ); }
  public function __setShaderName( sn:String ):String { shader = sn; return( shader ); }
}
