/*
 * Slider.cpp
 *
 *  Created on: 2008/08/02
 *      Author: syn
 */

#include <GL/gl.h>
#include <lo/lo.h>
#include "Slider.h"

Slider::Slider(const std::string& label, const int min, const int max, const int val)
:Controller(){
	mLabel = label;
	mMin = min;
	mMax = max;
	mVal = val;
}

Slider::~Slider() {
	// TODO Auto-generated destructor stub
}

void Slider::render(){
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(mLocX, mLocY, 0);

	// label

	// Bar
	float v;
	v = (float)mVal*100.0/(float)(mMax -mMin);
	glBegin(GL_TRIANGLE_STRIP);
	glVertex3f(0, 16, 0);
	glVertex3f(v, 16, 0);
	glVertex3f(0, 0, 0);
	glVertex3f(v, 0, 0);
	glEnd();

	// Frame
	glBegin(GL_LINE_STRIP);
	glVertex3f(0, 0, 0);
	glVertex3f(0, 16, 0);
	glVertex3f(100, 16, 0);
	glVertex3f(100, 0, 0);
	glVertex3f(0, 0, 0);
	glEnd();

	glPopMatrix();
}

void Slider::setValue(const int v){
	lo_address t = lo_address_new("127.0.0.1", "7700");
	lo_send(t, "/SQUARE_GENERATOR/duty", "i", v);

	mVal = v;
}

void Slider::handleMouseButtonDown(const int x, const int y){
	if(x < 0 || x > 100){
		return;
	}
	if(y < 0 || y > 16){
		return;
	}

	int val;
	val = x;	// TODO

	this->setValue(val);
}

void Slider::handleMouseMotion(const int btn, const int x, const int y){
	if(btn != 1){
		return;
	}
	if(x < 0 || x > 100){
		return;
	}
	if(y < 0 || y > 16){
		return;
	}

	int val;
	val = x;	// TODO

	this->setValue(val);
}

void Slider::drawStr(const std::string& str, const int x, const int y){
	const char* p = str.c_str();
	glRasterPos2f(x+mLocX, y+mLocY);
	for(int i = 0; p[i]; i++){

	}
}
