/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.poi;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.poi.hssf.usermodel.HSSFCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class POIAssignment {
    private POIAssignment() {
    }

    static <T> T getValue(HSSFCell cell, Class<T> clazz) {
        switch (cell.getCellType()) {
            case 3: {
                return null;
            }
            case 4: {
                if (clazz == Boolean.class) {
                    Boolean value = cell.getBooleanCellValue();
                    return clazz.cast(value);
                }
                if (clazz == Byte.class) {
                    T value = clazz.cast(cell.getBooleanCellValue() ? (byte)1 : 0);
                    return clazz.cast(value);
                }
                if (clazz == Short.class) {
                    Short value = cell.getBooleanCellValue() ? (short)1 : 0;
                    return clazz.cast(value);
                }
                if (clazz == Integer.class) {
                    Integer value = cell.getBooleanCellValue() ? 1 : 0;
                    return clazz.cast(value);
                }
                if (clazz == Long.class) {
                    Long value = cell.getBooleanCellValue() ? 1L : 0L;
                    return clazz.cast(value);
                }
                if (clazz == Float.class) {
                    Float value = Float.valueOf(cell.getBooleanCellValue() ? 1.0f : 0.0f);
                    return clazz.cast(value);
                }
                if (clazz == Double.class) {
                    Double value = cell.getBooleanCellValue() ? 1.0 : 0.0;
                    return clazz.cast(value);
                }
                if (clazz == BigInteger.class) {
                    BigInteger value = cell.getBooleanCellValue() ? BigInteger.ONE : BigInteger.ZERO;
                    return clazz.cast(value);
                }
                if (clazz == BigDecimal.class) {
                    BigDecimal value = cell.getBooleanCellValue() ? BigDecimal.ONE : BigDecimal.ZERO;
                    return clazz.cast(value);
                }
                if (clazz == AtomicBoolean.class) {
                    AtomicBoolean value = new AtomicBoolean(cell.getBooleanCellValue());
                    return clazz.cast(value);
                }
                if (clazz == AtomicInteger.class) {
                    AtomicInteger value = cell.getBooleanCellValue() ? new AtomicInteger(1) : new AtomicInteger(0);
                    return clazz.cast(value);
                }
                if (clazz == AtomicLong.class) {
                    AtomicLong value = cell.getBooleanCellValue() ? new AtomicLong(1L) : new AtomicLong(0L);
                    return clazz.cast(value);
                }
                if (clazz == String.class) {
                    String value = Boolean.toString(cell.getBooleanCellValue());
                    return clazz.cast(value);
                }
                if (clazz == StringBuilder.class) {
                    StringBuilder value = new StringBuilder().append(cell.getBooleanCellValue());
                    return clazz.cast(value);
                }
                if (clazz == StringBuffer.class) {
                    StringBuffer value = new StringBuffer().append(cell.getBooleanCellValue());
                    return clazz.cast(value);
                }
            }
            case 0: {
                if (clazz == Boolean.class) {
                    Boolean value = cell.getNumericCellValue() != 0.0;
                    return clazz.cast(value);
                }
                if (clazz == Byte.class) {
                    Byte value = Double.valueOf(cell.getNumericCellValue()).byteValue();
                    return clazz.cast(value);
                }
                if (clazz == Short.class) {
                    Short value = Double.valueOf(cell.getNumericCellValue()).shortValue();
                    return clazz.cast(value);
                }
                if (clazz == Integer.class) {
                    Integer value = Double.valueOf(cell.getNumericCellValue()).intValue();
                    return clazz.cast(value);
                }
                if (clazz == Long.class) {
                    Long value = Double.valueOf(cell.getNumericCellValue()).longValue();
                    return clazz.cast(value);
                }
                if (clazz == Float.class) {
                    Float value = Float.valueOf(Double.valueOf(cell.getNumericCellValue()).floatValue());
                    return clazz.cast(value);
                }
                if (clazz == Double.class) {
                    Double value = cell.getNumericCellValue();
                    return clazz.cast(value);
                }
                if (clazz == BigInteger.class) {
                    BigInteger value = new BigDecimal(cell.getNumericCellValue()).setScale(0, RoundingMode.DOWN).toBigInteger();
                    return clazz.cast(value);
                }
                if (clazz == BigDecimal.class) {
                    BigDecimal value = new BigDecimal(cell.getNumericCellValue());
                    return clazz.cast(value);
                }
                if (clazz == AtomicBoolean.class) {
                    AtomicBoolean value = new AtomicBoolean(cell.getNumericCellValue() != 0.0);
                    return clazz.cast(value);
                }
                if (clazz == AtomicInteger.class) {
                    AtomicInteger value = new AtomicInteger(Double.valueOf(cell.getNumericCellValue()).intValue());
                    return clazz.cast(value);
                }
                if (clazz == AtomicLong.class) {
                    AtomicLong value = new AtomicLong(Double.valueOf(cell.getNumericCellValue()).longValue());
                    return clazz.cast(value);
                }
                if (clazz == Date.class || clazz.getSuperclass() == Date.class) {
                    Date value = cell.getDateCellValue();
                    return clazz.cast(value);
                }
                if (clazz == String.class) {
                    String value = Double.toString(cell.getNumericCellValue());
                    return clazz.cast(value);
                }
                if (clazz == StringBuilder.class) {
                    StringBuilder value = new StringBuilder().append(cell.getNumericCellValue());
                    return clazz.cast(value);
                }
                if (clazz == StringBuffer.class) {
                    StringBuffer value = new StringBuffer().append(cell.getNumericCellValue());
                    return clazz.cast(value);
                }
            }
            case 1: {
                if (clazz == Boolean.class) {
                    Boolean value = Boolean.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == Byte.class) {
                    Byte value = Byte.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == Short.class) {
                    Short value = Short.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == Integer.class) {
                    Integer value = Integer.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == Long.class) {
                    Long value = Long.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == Float.class) {
                    Float value = Float.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == Double.class) {
                    Double value = Double.valueOf(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == BigInteger.class) {
                    BigInteger value = new BigInteger(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == BigDecimal.class) {
                    BigDecimal value = new BigDecimal(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz == AtomicBoolean.class) {
                    AtomicBoolean value = new AtomicBoolean(Boolean.valueOf(cell.getStringCellValue()));
                    return clazz.cast(value);
                }
                if (clazz == AtomicInteger.class) {
                    AtomicInteger value = new AtomicInteger(Integer.valueOf(cell.getStringCellValue()));
                    return clazz.cast(value);
                }
                if (clazz == AtomicLong.class) {
                    AtomicLong value = new AtomicLong(Long.valueOf(cell.getStringCellValue()));
                    return clazz.cast(value);
                }
                if (clazz == String.class) {
                    String value = cell.getStringCellValue();
                    return clazz.cast(value);
                }
                if (clazz == StringBuilder.class) {
                    StringBuilder value = new StringBuilder(cell.getStringCellValue());
                    return clazz.cast(value);
                }
                if (clazz != StringBuffer.class) break;
                StringBuffer value = new StringBuffer(cell.getStringCellValue());
                return clazz.cast(value);
            }
        }
        return null;
    }

    static void setValue(HSSFCell cell, Object value) {
        if (value == null) {
            cell.setCellType(3);
            return;
        }
        if (value.getClass() == Boolean.class) {
            cell.setCellType(4);
            cell.setCellValue(((Boolean)value).booleanValue());
            return;
        }
        if (value instanceof Number) {
            cell.setCellType(0);
            cell.setCellValue(((Number)value).doubleValue());
            return;
        }
        if (value instanceof Date) {
            cell.setCellType(0);
            cell.setCellValue((Date)value);
            return;
        }
        if (value instanceof Character) {
            cell.setCellType(1);
            cell.setCellValue(((Character)value).toString());
            return;
        }
        if (value instanceof CharSequence) {
            cell.setCellType(1);
            cell.setCellValue(value.toString());
            return;
        }
        cell.setCellType(3);
    }
}

