/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.poi;

import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.RangeProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XWorkbook;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POICell;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POIRange;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POIWorkbook;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class POISheet
implements XSheet {
    private POIWorkbook poiWorkbook;
    private HSSFSheet sheet;

    POISheet(POIWorkbook poiWorkbook) {
        HSSFWorkbook workbook = poiWorkbook.getWorkbook();
        this.sheet = workbook.createSheet();
        this.poiWorkbook = poiWorkbook;
    }

    POISheet(POIWorkbook poiWorkbook, int index) {
        HSSFWorkbook workbook = poiWorkbook.getWorkbook();
        while (index >= workbook.getNumberOfSheets()) {
            workbook.createSheet();
        }
        this.sheet = workbook.getSheetAt(index);
        this.poiWorkbook = poiWorkbook;
    }

    public String getName() {
        HSSFWorkbook workbook = this.poiWorkbook.getWorkbook();
        int index = 0;
        while (index < workbook.getNumberOfSheets()) {
            if (this.sheet == workbook.getSheetAt(index)) {
                return workbook.getSheetName(index);
            }
            ++index;
        }
        return null;
    }

    public void setName(String name) {
        HSSFWorkbook workbook = this.poiWorkbook.getWorkbook();
        int index = 0;
        while (index < workbook.getNumberOfSheets()) {
            if (this.sheet == workbook.getSheetAt(index)) {
                workbook.setSheetName(index, name, (short)1);
                break;
            }
            ++index;
        }
    }

    public XCell getCell(CellProvider cellProvider) {
        return new POICell(this, cellProvider);
    }

    public XRange getRange(RangeProvider rangeProvider) {
        return new POIRange(this, rangeProvider);
    }

    public double getRowHeight(RowProvider rowProvider) {
        HSSFRow row = this.sheet.getRow(rowProvider.row()) == null ? this.sheet.createRow(rowProvider.row()) : this.sheet.getRow(rowProvider.row());
        return (double)row.getHeight() / 20.0;
    }

    public void setRowHeight(RowProvider rowProvider, double height) {
        HSSFRow row = this.sheet.getRow(rowProvider.row()) == null ? this.sheet.createRow(rowProvider.row()) : this.sheet.getRow(rowProvider.row());
        row.setHeight((short)(height * 20.0));
    }

    public double getColumnWidth(ColumnProvider columnProvider) {
        return (double)this.sheet.getColumnWidth((short)columnProvider.column()) / 256.0;
    }

    public void setColumnWidth(ColumnProvider columnProvider, double width) {
        this.sheet.setColumnWidth((short)columnProvider.column(), (short)(width * 256.0));
    }

    public XWorkbook getWorkbook() {
        return this.poiWorkbook;
    }

    HSSFSheet getSheet() {
        return this.sheet;
    }
}

