/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.poi;

import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POIAssignment;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POIResources;
import jp.coppermine.voyager.xlsmaker.model.impl.poi.POISheet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POICell
implements XCell {
    private POISheet poiSheet;
    private POIResources resources;
    private CellUnit cellUnit;
    private HSSFCell cell;

    POICell(POISheet ssSheet, CellProvider cellProvider) {
        int rowIndex = cellProvider.row();
        short colIndex = (short)cellProvider.column();
        HSSFSheet sheet = ssSheet.getSheet();
        HSSFRow row = sheet.getRow(rowIndex) == null ? sheet.createRow(rowIndex) : sheet.getRow(rowIndex);
        this.cell = row.getCell(colIndex) == null ? row.createCell(colIndex) : row.getCell(colIndex);
        this.cell.setEncoding((short)1);
        this.poiSheet = ssSheet;
        this.cellUnit = cellProvider.toCellUnit();
        this.resources = new POIResources(ssSheet);
    }

    @Override
    public <T> T getValue(Class<T> clazz) {
        return POIAssignment.getValue(this.cell, clazz);
    }

    @Override
    public void setValue(Object value) {
        POIAssignment.setValue(this.cell, value);
    }

    @Override
    public String getStringValue() {
        return this.cell.getStringCellValue();
    }

    @Override
    public String getFormula() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFormula(String formula) {
        throw new UnsupportedOperationException();
    }

    @Override
    public XStyle getStyle() {
        return this.resources.getXStyle(this.cell.getCellStyle());
    }

    @Override
    public void setStyle(XStyle style) {
        this.cell.setCellStyle(this.resources.findCellStyle(style));
    }

    @Override
    public XSheet getSheet() {
        return this.poiSheet;
    }

    @Override
    public CellUnit toCellUnit() {
        return this.cellUnit.toCellUnit();
    }

    @Override
    public int row() {
        return this.cellUnit.row();
    }

    @Override
    public int column() {
        return this.cellUnit.column();
    }
}

