/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model;

import java.io.Serializable;
import jp.coppermine.voyager.xlsmaker.enums.Alignment;
import jp.coppermine.voyager.xlsmaker.enums.BorderStyle;
import jp.coppermine.voyager.xlsmaker.enums.Color;
import jp.coppermine.voyager.xlsmaker.enums.FillPattern;
import jp.coppermine.voyager.xlsmaker.enums.VerticalAlignment;
import jp.coppermine.voyager.xlsmaker.model.XFont;

public class XStyle
implements Serializable {
    private static final long serialVersionUID = 8746433299442519066L;
    private short dataFormat;
    private String dataFormatString;
    private Alignment alignment;
    private VerticalAlignment verticalAlignment;
    private short indention;
    private short rotation;
    private boolean wrapText;
    private BorderStyle borderTop;
    private BorderStyle borderBottom;
    private BorderStyle borderLeft;
    private BorderStyle borderRight;
    private Color topBorderColor;
    private Color bottomBorderColor;
    private Color leftBorderColor;
    private Color rightBorderColor;
    private XFont xFont;
    private Color fillForegroundColor;
    private Color fillBackgroundColor;
    private FillPattern fillPattern;
    public static final XStyle defaultPOI2Style = XStyle.builder().font(XFont.defaultFont).borderColor(Color.OVERFLOW).build();
    public static final XStyle defaultBiff8Style = XStyle.builder().font(XFont.defaultFont).borderColor(Color.OVERFLOW).background(Color.UNDERFLOW).build();
    public static final XStyle defaultOoxmlStyle = XStyle.builder().font(XFont.defaultOoxmlFont).build();

    private XStyle() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(XStyle xStyle) {
        return xStyle == null ? new Builder() : new Builder(xStyle);
    }

    public short getDataFormat() {
        return this.dataFormat;
    }

    public String getDataFormatString() {
        return this.dataFormatString;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public short getIndention() {
        return this.indention;
    }

    public short getRotation() {
        return this.rotation;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public BorderStyle getBorderTop() {
        return this.borderTop;
    }

    public BorderStyle getBorderBottom() {
        return this.borderBottom;
    }

    public BorderStyle getBorderLeft() {
        return this.borderLeft;
    }

    public BorderStyle getBorderRight() {
        return this.borderRight;
    }

    public Color getTopBorderColor() {
        return this.topBorderColor;
    }

    public Color getBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public Color getLeftBorderColor() {
        return this.leftBorderColor;
    }

    public Color getRightBorderColor() {
        return this.rightBorderColor;
    }

    public XFont getXFont() {
        return this.xFont;
    }

    public Color getFillForegroundColor() {
        return this.fillForegroundColor;
    }

    public Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public FillPattern getFillPattern() {
        return this.fillPattern;
    }

    public static XStyle copy(XStyle src, XStyle dest) {
        dest.dataFormat = src.dataFormat;
        dest.dataFormatString = src.dataFormatString;
        dest.alignment = src.alignment;
        dest.verticalAlignment = src.verticalAlignment;
        dest.indention = src.indention;
        dest.rotation = src.rotation;
        dest.wrapText = src.wrapText;
        dest.xFont = src.xFont;
        dest.borderTop = src.borderTop;
        dest.borderBottom = src.borderBottom;
        dest.borderLeft = src.borderLeft;
        dest.borderRight = src.borderRight;
        dest.topBorderColor = src.topBorderColor;
        dest.bottomBorderColor = src.bottomBorderColor;
        dest.leftBorderColor = src.leftBorderColor;
        dest.rightBorderColor = src.rightBorderColor;
        dest.fillForegroundColor = src.fillForegroundColor;
        dest.fillBackgroundColor = src.fillBackgroundColor;
        dest.fillPattern = src.fillPattern;
        return dest;
    }

    public static XStyle copyFrom(XStyle src) {
        return XStyle.copy(src, new XStyle());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alignment == null ? 0 : this.alignment.hashCode());
        result = 31 * result + (this.borderBottom == null ? 0 : this.borderBottom.hashCode());
        result = 31 * result + (this.borderLeft == null ? 0 : this.borderLeft.hashCode());
        result = 31 * result + (this.borderRight == null ? 0 : this.borderRight.hashCode());
        result = 31 * result + (this.borderTop == null ? 0 : this.borderTop.hashCode());
        result = 31 * result + (this.bottomBorderColor == null ? 0 : this.bottomBorderColor.hashCode());
        result = 31 * result + this.dataFormat;
        result = 31 * result + (this.dataFormatString == null ? 0 : this.dataFormatString.hashCode());
        result = 31 * result + (this.fillBackgroundColor == null ? 0 : this.fillBackgroundColor.hashCode());
        result = 31 * result + (this.fillForegroundColor == null ? 0 : this.fillForegroundColor.hashCode());
        result = 31 * result + (this.fillPattern == null ? 0 : this.fillPattern.hashCode());
        result = 31 * result + this.indention;
        result = 31 * result + (this.leftBorderColor == null ? 0 : this.leftBorderColor.hashCode());
        result = 31 * result + (this.rightBorderColor == null ? 0 : this.rightBorderColor.hashCode());
        result = 31 * result + this.rotation;
        result = 31 * result + (this.topBorderColor == null ? 0 : this.topBorderColor.hashCode());
        result = 31 * result + (this.verticalAlignment == null ? 0 : this.verticalAlignment.hashCode());
        result = 31 * result + (this.wrapText ? 1231 : 1237);
        result = 31 * result + (this.xFont == null ? 0 : this.xFont.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XStyle other = (XStyle)obj;
        if (this.alignment != other.alignment) {
            return false;
        }
        if (this.borderBottom != other.borderBottom) {
            return false;
        }
        if (this.borderLeft != other.borderLeft) {
            return false;
        }
        if (this.borderRight != other.borderRight) {
            return false;
        }
        if (this.borderTop != other.borderTop) {
            return false;
        }
        if (this.bottomBorderColor != other.bottomBorderColor) {
            return false;
        }
        if (this.dataFormat != other.dataFormat) {
            return false;
        }
        if (this.dataFormatString == null ? other.dataFormatString != null : !this.dataFormatString.equals(other.dataFormatString)) {
            return false;
        }
        if (this.fillBackgroundColor != other.fillBackgroundColor) {
            return false;
        }
        if (this.fillForegroundColor != other.fillForegroundColor) {
            return false;
        }
        if (this.fillPattern != other.fillPattern) {
            return false;
        }
        if (this.indention != other.indention) {
            return false;
        }
        if (this.leftBorderColor != other.leftBorderColor) {
            return false;
        }
        if (this.rightBorderColor != other.rightBorderColor) {
            return false;
        }
        if (this.rotation != other.rotation) {
            return false;
        }
        if (this.topBorderColor != other.topBorderColor) {
            return false;
        }
        if (this.verticalAlignment != other.verticalAlignment) {
            return false;
        }
        if (this.wrapText != other.wrapText) {
            return false;
        }
        return !(this.xFont == null ? other.xFont != null : !this.xFont.equals(other.xFont));
    }

    public String toString() {
        return "XStyle [dataFormat=" + this.dataFormat + ", dataFormatString=" + this.dataFormatString + ", alignment=" + (Object)((Object)this.alignment) + ", verticalAlignment=" + (Object)((Object)this.verticalAlignment) + ", indention=" + this.indention + ", rotation=" + this.rotation + ", wrapText=" + this.wrapText + ", borderTop=" + (Object)((Object)this.borderTop) + ", borderBottom=" + (Object)((Object)this.borderBottom) + ", borderLeft=" + (Object)((Object)this.borderLeft) + ", borderRight=" + (Object)((Object)this.borderRight) + ", topBorderColor=" + (Object)((Object)this.topBorderColor) + ", bottomBorderColor=" + (Object)((Object)this.bottomBorderColor) + ", leftBorderColor=" + (Object)((Object)this.leftBorderColor) + ", rightBorderColor=" + (Object)((Object)this.rightBorderColor) + ", xFont=" + this.xFont + ", fillForegroundColor=" + (Object)((Object)this.fillForegroundColor) + ", fillBackgroundColor=" + (Object)((Object)this.fillBackgroundColor) + ", fillPattern=" + (Object)((Object)this.fillPattern) + "]";
    }

    /* synthetic */ XStyle(XStyle xStyle) {
        this();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = -4881957462397932648L;
        private int dataFormat;
        private String dataFormatString;
        private Alignment alignment;
        private VerticalAlignment verticalAlignment;
        private int indention;
        private int rotation;
        private boolean wrapText;
        private XFont xFont;
        private BorderStyle borderTop;
        private BorderStyle borderBottom;
        private BorderStyle borderLeft;
        private BorderStyle borderRight;
        private Color topBorderColor;
        private Color bottomBorderColor;
        private Color leftBorderColor;
        private Color rightBorderColor;
        private Color fillForegroundColor;
        private Color fillBackgroundColor;
        private FillPattern fillPattern;

        private Builder() {
            this.dataFormat = 0;
            this.dataFormatString = null;
            this.alignment = Alignment.GENERAL;
            this.verticalAlignment = VerticalAlignment.BOTTOM;
            this.indention = 0;
            this.rotation = 0;
            this.wrapText = false;
            this.xFont = null;
            this.borderTop = BorderStyle.NONE;
            this.borderBottom = BorderStyle.NONE;
            this.borderLeft = BorderStyle.NONE;
            this.borderRight = BorderStyle.NONE;
            this.topBorderColor = Color.BLACK;
            this.bottomBorderColor = Color.BLACK;
            this.leftBorderColor = Color.BLACK;
            this.rightBorderColor = Color.BLACK;
            this.fillForegroundColor = Color.AUTOMATIC;
            this.fillBackgroundColor = Color.AUTOMATIC;
            this.fillPattern = FillPattern.NO_FILL;
        }

        public Builder(XStyle xStyle) {
            this.dataFormat = xStyle.dataFormat;
            this.dataFormatString = xStyle.dataFormatString;
            this.alignment = xStyle.alignment;
            this.verticalAlignment = xStyle.verticalAlignment;
            this.indention = xStyle.indention;
            this.rotation = xStyle.rotation;
            this.wrapText = xStyle.wrapText;
            this.xFont = xStyle.xFont;
            this.borderTop = xStyle.borderTop;
            this.borderBottom = xStyle.borderBottom;
            this.borderLeft = xStyle.borderLeft;
            this.borderRight = xStyle.borderRight;
            this.topBorderColor = xStyle.topBorderColor;
            this.bottomBorderColor = xStyle.bottomBorderColor;
            this.leftBorderColor = xStyle.leftBorderColor;
            this.rightBorderColor = xStyle.rightBorderColor;
            this.fillForegroundColor = xStyle.fillForegroundColor;
            this.fillBackgroundColor = xStyle.fillBackgroundColor;
            this.fillPattern = xStyle.fillPattern;
        }

        public Builder dataFormat(int dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder dataFormat(String dataFormatString) {
            this.dataFormatString = dataFormatString;
            return this;
        }

        public Builder alignment(Alignment alignment) {
            this.alignment = alignment;
            return this;
        }

        public Builder verticalAlignment(VerticalAlignment verticalAlignment) {
            this.verticalAlignment = verticalAlignment;
            return this;
        }

        public Builder indention(int indention) {
            this.indention = indention;
            return this;
        }

        public Builder rotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder wrapText(boolean wrapText) {
            this.wrapText = wrapText;
            return this;
        }

        public Builder font(XFont xFont) {
            this.xFont = xFont;
            return this;
        }

        public Builder borderTop(BorderStyle borderStyle) {
            this.borderTop = borderStyle;
            return this;
        }

        public Builder borderTop(BorderStyle borderStyle, Color color) {
            this.borderTop = borderStyle;
            this.topBorderColor = color;
            return this;
        }

        public Builder borderBottom(BorderStyle borderStyle) {
            this.borderBottom = borderStyle;
            return this;
        }

        public Builder borderBottom(BorderStyle borderStyle, Color color) {
            this.borderBottom = borderStyle;
            this.bottomBorderColor = color;
            return this;
        }

        public Builder borderLeft(BorderStyle borderStyle) {
            this.borderLeft = borderStyle;
            return this;
        }

        public Builder borderLeft(BorderStyle borderStyle, Color color) {
            this.borderLeft = borderStyle;
            this.leftBorderColor = color;
            return this;
        }

        public Builder borderRight(BorderStyle borderStyle) {
            this.borderRight = borderStyle;
            return this;
        }

        public Builder borderRight(BorderStyle borderStyle, Color color) {
            this.borderRight = borderStyle;
            this.rightBorderColor = color;
            return this;
        }

        public Builder topBorderColor(Color color) {
            this.topBorderColor = color;
            return this;
        }

        public Builder bottomBorderColor(Color color) {
            this.bottomBorderColor = color;
            return this;
        }

        public Builder leftBorderColor(Color color) {
            this.leftBorderColor = color;
            return this;
        }

        public Builder rightBorderColor(Color color) {
            this.rightBorderColor = color;
            return this;
        }

        public Builder border(BorderStyle borderStyle) {
            this.borderTop = borderStyle;
            this.borderBottom = borderStyle;
            this.borderLeft = borderStyle;
            this.borderRight = borderStyle;
            return this;
        }

        public Builder border(BorderStyle borderStyle, Color color) {
            this.borderTop = borderStyle;
            this.borderBottom = borderStyle;
            this.borderLeft = borderStyle;
            this.borderRight = borderStyle;
            this.topBorderColor = color;
            this.bottomBorderColor = color;
            this.leftBorderColor = color;
            this.rightBorderColor = color;
            return this;
        }

        public Builder borderColor(Color color) {
            this.topBorderColor = color;
            this.bottomBorderColor = color;
            this.leftBorderColor = color;
            this.rightBorderColor = color;
            return this;
        }

        public Builder foreground(Color color) {
            this.fillForegroundColor = color;
            return this;
        }

        public Builder background(Color color) {
            this.fillBackgroundColor = color;
            return this;
        }

        public Builder pattern(FillPattern fillPattern) {
            this.fillPattern = fillPattern;
            return this;
        }

        public XStyle build() {
            XStyle xStyle = new XStyle(null);
            xStyle.dataFormat = (short)this.dataFormat;
            xStyle.dataFormatString = this.dataFormatString;
            xStyle.alignment = this.alignment == null ? Alignment.GENERAL : this.alignment;
            xStyle.verticalAlignment = this.verticalAlignment == null ? VerticalAlignment.BOTTOM : this.verticalAlignment;
            xStyle.indention = (short)this.indention;
            xStyle.rotation = (short)this.rotation;
            xStyle.wrapText = this.wrapText;
            xStyle.xFont = this.xFont == null ? XFont.defaultFont : this.xFont;
            xStyle.borderTop = this.borderTop == null ? BorderStyle.NONE : this.borderTop;
            xStyle.borderBottom = this.borderBottom == null ? BorderStyle.NONE : this.borderBottom;
            xStyle.borderLeft = this.borderLeft == null ? BorderStyle.NONE : this.borderLeft;
            xStyle.borderRight = this.borderRight == null ? BorderStyle.NONE : this.borderRight;
            xStyle.topBorderColor = this.topBorderColor == null ? Color.BLACK : this.topBorderColor;
            xStyle.bottomBorderColor = this.bottomBorderColor == null ? Color.BLACK : this.bottomBorderColor;
            xStyle.leftBorderColor = this.leftBorderColor == null ? Color.BLACK : this.leftBorderColor;
            xStyle.rightBorderColor = this.rightBorderColor == null ? Color.BLACK : this.rightBorderColor;
            xStyle.fillForegroundColor = this.fillForegroundColor == null ? Color.AUTOMATIC : this.fillForegroundColor;
            xStyle.fillBackgroundColor = this.fillBackgroundColor == null ? Color.AUTOMATIC : this.fillBackgroundColor;
            xStyle.fillPattern = this.fillPattern == null ? FillPattern.NO_FILL : this.fillPattern;
            return xStyle;
        }

        public String toString() {
            return "Builder [dataFormat=" + this.dataFormat + ", dataFormatString=" + this.dataFormatString + ", alignment=" + (Object)((Object)this.alignment) + ", verticalAlignment=" + (Object)((Object)this.verticalAlignment) + ", indention=" + this.indention + ", rotation=" + this.rotation + ", wrapText=" + this.wrapText + ", xFont=" + this.xFont + ", borderTop=" + (Object)((Object)this.borderTop) + ", borderBottom=" + (Object)((Object)this.borderBottom) + ", borderLeft=" + (Object)((Object)this.borderLeft) + ", borderRight=" + (Object)((Object)this.borderRight) + ", topBorderColor=" + (Object)((Object)this.topBorderColor) + ", bottomBorderColor=" + (Object)((Object)this.bottomBorderColor) + ", leftBorderColor=" + (Object)((Object)this.leftBorderColor) + ", rightBorderColor=" + (Object)((Object)this.rightBorderColor) + ", fillForegroundColor=" + (Object)((Object)this.fillForegroundColor) + ", fillBackgroundColor=" + (Object)((Object)this.fillBackgroundColor) + ", fillPattern=" + (Object)((Object)this.fillPattern) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alignment == null ? 0 : this.alignment.hashCode());
            result = 31 * result + (this.borderBottom == null ? 0 : this.borderBottom.hashCode());
            result = 31 * result + (this.borderLeft == null ? 0 : this.borderLeft.hashCode());
            result = 31 * result + (this.borderRight == null ? 0 : this.borderRight.hashCode());
            result = 31 * result + (this.borderTop == null ? 0 : this.borderTop.hashCode());
            result = 31 * result + (this.bottomBorderColor == null ? 0 : this.bottomBorderColor.hashCode());
            result = 31 * result + this.dataFormat;
            result = 31 * result + (this.dataFormatString == null ? 0 : this.dataFormatString.hashCode());
            result = 31 * result + (this.fillBackgroundColor == null ? 0 : this.fillBackgroundColor.hashCode());
            result = 31 * result + (this.fillForegroundColor == null ? 0 : this.fillForegroundColor.hashCode());
            result = 31 * result + (this.fillPattern == null ? 0 : this.fillPattern.hashCode());
            result = 31 * result + this.indention;
            result = 31 * result + (this.leftBorderColor == null ? 0 : this.leftBorderColor.hashCode());
            result = 31 * result + (this.rightBorderColor == null ? 0 : this.rightBorderColor.hashCode());
            result = 31 * result + this.rotation;
            result = 31 * result + (this.topBorderColor == null ? 0 : this.topBorderColor.hashCode());
            result = 31 * result + (this.verticalAlignment == null ? 0 : this.verticalAlignment.hashCode());
            result = 31 * result + (this.wrapText ? 1231 : 1237);
            result = 31 * result + (this.xFont == null ? 0 : this.xFont.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.alignment != other.alignment) {
                return false;
            }
            if (this.borderBottom != other.borderBottom) {
                return false;
            }
            if (this.borderLeft != other.borderLeft) {
                return false;
            }
            if (this.borderRight != other.borderRight) {
                return false;
            }
            if (this.borderTop != other.borderTop) {
                return false;
            }
            if (this.bottomBorderColor != other.bottomBorderColor) {
                return false;
            }
            if (this.dataFormat != other.dataFormat) {
                return false;
            }
            if (this.dataFormatString == null ? other.dataFormatString != null : !this.dataFormatString.equals(other.dataFormatString)) {
                return false;
            }
            if (this.fillBackgroundColor != other.fillBackgroundColor) {
                return false;
            }
            if (this.fillForegroundColor != other.fillForegroundColor) {
                return false;
            }
            if (this.fillPattern != other.fillPattern) {
                return false;
            }
            if (this.indention != other.indention) {
                return false;
            }
            if (this.leftBorderColor != other.leftBorderColor) {
                return false;
            }
            if (this.rightBorderColor != other.rightBorderColor) {
                return false;
            }
            if (this.rotation != other.rotation) {
                return false;
            }
            if (this.topBorderColor != other.topBorderColor) {
                return false;
            }
            if (this.verticalAlignment != other.verticalAlignment) {
                return false;
            }
            if (this.wrapText != other.wrapText) {
                return false;
            }
            return !(this.xFont == null ? other.xFont != null : !this.xFont.equals(other.xFont));
        }
    }
}

