/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model;

import java.io.Serializable;
import jp.coppermine.voyager.xlsmaker.enums.Boldweight;
import jp.coppermine.voyager.xlsmaker.enums.Color;
import jp.coppermine.voyager.xlsmaker.enums.TypeOffset;
import jp.coppermine.voyager.xlsmaker.enums.Underline;
import jp.coppermine.voyager.xlsmaker.model.SystemFonts;

public class XFont
implements Serializable {
    private static final long serialVersionUID = 5575628000655446353L;
    private String name;
    private short height;
    private Color color;
    private Boldweight boldweight;
    private boolean italic;
    private boolean strikeout;
    private TypeOffset typeOffset;
    private Underline underline;
    public static final XFont defaultFont = XFont.builder().name(SystemFonts.Arial).height(200).color(Color.FONT_NORMAL).build();
    public static final XFont defaultOoxmlFont = XFont.builder().name(SystemFonts.Calibri).height(220).color(Color.BLACK).build();

    private XFont() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(XFont xFont) {
        return xFont == null ? new Builder() : new Builder(xFont);
    }

    public static Builder biff8Builder() {
        return new Builder().name(SystemFonts.Arial).height(200).color(Color.FONT_NORMAL);
    }

    public static Builder ooxmlBuilder() {
        return new Builder().name(SystemFonts.Calibri).height(220).color(Color.BLACK);
    }

    public String getName() {
        return this.name;
    }

    public short getHeight() {
        return this.height;
    }

    public Color getColor() {
        return this.color;
    }

    public Boldweight getBoldweight() {
        return this.boldweight;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isStrikeout() {
        return this.strikeout;
    }

    public TypeOffset getTypeOffset() {
        return this.typeOffset;
    }

    public Underline getUnderline() {
        return this.underline;
    }

    public static XFont copy(XFont src, XFont dest) {
        dest.name = src.name;
        dest.height = src.height;
        dest.color = src.color;
        dest.boldweight = src.boldweight;
        dest.italic = src.italic;
        dest.strikeout = src.strikeout;
        dest.typeOffset = src.typeOffset;
        dest.underline = src.underline;
        return dest;
    }

    public static XFont copyFrom(XFont src) {
        return XFont.copy(src, new XFont());
    }

    public String toString() {
        return "XFont [name=" + this.name + ", height=" + this.height + ", color=" + (Object)((Object)this.color) + ", boldweight=" + (Object)((Object)this.boldweight) + ", italic=" + this.italic + ", strikeout=" + this.strikeout + ", typeOffset=" + (Object)((Object)this.typeOffset) + ", underline=" + (Object)((Object)this.underline) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boldweight == null ? 0 : this.boldweight.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + this.height;
        result = 31 * result + (this.italic ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.strikeout ? 1231 : 1237);
        result = 31 * result + (this.typeOffset == null ? 0 : this.typeOffset.hashCode());
        result = 31 * result + (this.underline == null ? 0 : this.underline.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XFont other = (XFont)obj;
        if (this.boldweight != other.boldweight) {
            return false;
        }
        if (this.color != other.color) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.italic != other.italic) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.strikeout != other.strikeout) {
            return false;
        }
        if (this.typeOffset != other.typeOffset) {
            return false;
        }
        return this.underline == other.underline;
    }

    /* synthetic */ XFont(XFont xFont) {
        this();
    }

    public static class Builder
    implements Serializable {
        private static final long serialVersionUID = -7547038833338422415L;
        private String name;
        private int height;
        private double size;
        private Color color;
        private Boldweight boldweight;
        private boolean italic;
        private boolean strikeout;
        private TypeOffset typeOffset;
        private Underline underline;

        private Builder() {
            this.name = SystemFonts.Arial.getName();
            this.height = 200;
            this.size = 0.0;
            this.color = null;
            this.boldweight = Boldweight.NORMAL;
            this.italic = false;
            this.strikeout = false;
            this.typeOffset = TypeOffset.NONE;
            this.underline = Underline.NONE;
        }

        private Builder(XFont xFont) {
            this.name = xFont.name;
            this.height = xFont.height;
            this.size = 0.0;
            this.color = xFont.color;
            this.boldweight = xFont.boldweight;
            this.italic = xFont.italic;
            this.strikeout = xFont.strikeout;
            this.typeOffset = xFont.typeOffset;
            this.underline = xFont.underline;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder name(SystemFonts systemFonts) {
            this.name = systemFonts.getName();
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            this.size = 0.0;
            return this;
        }

        public Builder size(double size) {
            this.height = 0;
            this.size = size;
            return this;
        }

        public Builder color(Color color) {
            this.color = color;
            return this;
        }

        public Builder boldweight(Boldweight boldweight) {
            this.boldweight = boldweight;
            return this;
        }

        public Builder italic(boolean italic) {
            this.italic = italic;
            return this;
        }

        public Builder strikeout(boolean strikeout) {
            this.strikeout = strikeout;
            return this;
        }

        public Builder typeOffset(TypeOffset typeOffset) {
            this.typeOffset = typeOffset;
            return this;
        }

        public Builder underline(Underline underline) {
            this.underline = underline;
            return this;
        }

        public XFont build() {
            XFont xFont = new XFont(null);
            if (this.name == null) {
                throw new IllegalArgumentException("\"name\" must be not null");
            }
            xFont.name = this.name;
            if (this.height <= 0 && this.size <= 0.0) {
                throw new IllegalArgumentException("Either \"height\" or \"size\" must be above zero");
            }
            xFont.height = this.height > 0 ? (short)this.height : (short)(this.size * 20.0);
            xFont.color = this.color == null ? Color.BLACK : this.color;
            xFont.boldweight = this.boldweight == null ? Boldweight.NORMAL : this.boldweight;
            xFont.italic = this.italic;
            xFont.strikeout = this.strikeout;
            xFont.typeOffset = this.typeOffset == null ? TypeOffset.NONE : this.typeOffset;
            xFont.underline = this.underline == null ? Underline.NONE : this.underline;
            return xFont;
        }

        public String toString() {
            return "Builder [name=" + this.name + ", height=" + this.height + ", size=" + this.size + ", color=" + (Object)((Object)this.color) + ", boldweight=" + (Object)((Object)this.boldweight) + ", italic=" + this.italic + ", strikeout=" + this.strikeout + ", typeOffset=" + (Object)((Object)this.typeOffset) + ", underline=" + (Object)((Object)this.underline) + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.boldweight == null ? 0 : this.boldweight.hashCode());
            result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
            result = 31 * result + this.height;
            result = 31 * result + (this.italic ? 1231 : 1237);
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            long temp = Double.doubleToLongBits(this.size);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (this.strikeout ? 1231 : 1237);
            result = 31 * result + (this.typeOffset == null ? 0 : this.typeOffset.hashCode());
            result = 31 * result + (this.underline == null ? 0 : this.underline.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Builder other = (Builder)obj;
            if (this.boldweight != other.boldweight) {
                return false;
            }
            if (this.color != other.color) {
                return false;
            }
            if (this.height != other.height) {
                return false;
            }
            if (this.italic != other.italic) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (Double.doubleToLongBits(this.size) != Double.doubleToLongBits(other.size)) {
                return false;
            }
            if (this.strikeout != other.strikeout) {
                return false;
            }
            if (this.typeOffset != other.typeOffset) {
                return false;
            }
            return this.underline == other.underline;
        }
    }
}

