/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.coord;

import java.io.Serializable;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;

public final class ColumnUnit
implements ColumnProvider,
Serializable {
    private static final long serialVersionUID = 2351008403143805340L;
    public static final ColumnUnit ORIGIN = new ColumnUnit(0);
    private final int column;

    private ColumnUnit(int column) {
        this.column = column;
    }

    public static ColumnUnit at(int column) {
        return new ColumnUnit(column);
    }

    public static ColumnUnit from(ColumnProvider columnProvider) {
        return new ColumnUnit(columnProvider.column());
    }

    public static ColumnUnit of(String address) {
        address = address.replaceFirst("^([A-Za-z]+)(\\d+)?$", "$1");
        int n = 0;
        char[] cArray = address.toUpperCase().toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            n = n * 26 + (c - 65 + 1);
            ++n3;
        }
        return new ColumnUnit(n - 1);
    }

    public int column() {
        return this.column;
    }

    public ColumnUnit shift(int columns) {
        return new ColumnUnit(this.column + columns);
    }

    public ColumnUnit shift(ColumnProvider columnProvider) {
        return new ColumnUnit(this.column + columnProvider.column());
    }

    public String toString() {
        int column = this.column;
        StringBuilder address = new StringBuilder();
        while (column >= 0) {
            address.insert(0, (char)(65 + column % 26));
            column /= 26;
            --column;
        }
        return address.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnUnit other = (ColumnUnit)obj;
        return this.column == other.column;
    }
}

