/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jp.coppermine.voyager.reflect.Assignments;
import jp.coppermine.voyager.reflect.ReflectorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflector {
    private static Map<Class<?>, Reflector> reflectors;
    private Class<?> clazz;
    private ConstructorsCollection constructors;
    private MethodsCollection methods;
    private FieldsCollection fields;

    public static final Reflector getReflector(Class<?> clazz) {
        if (reflectors == null) {
            reflectors = new ConcurrentHashMap();
        }
        if (!reflectors.containsKey(clazz)) {
            reflectors.put(clazz, new Reflector(clazz));
        }
        return reflectors.get(clazz);
    }

    private Reflector(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.clazz = clazz;
    }

    public Class<?> getTarget() {
        return this.clazz;
    }

    public Object newInstance(Object ... initargs) {
        Constructor<?> constructor = this.getConstructor(initargs);
        if (constructor == null) {
            throw new ReflectorException("this constructor is not found");
        }
        try {
            boolean accessible = constructor.isAccessible();
            constructor.setAccessible(true);
            Object instance = constructor.newInstance(initargs);
            constructor.setAccessible(accessible);
            return instance;
        }
        catch (InstantiationException e) {
            throw new ReflectorException("reflector cannot create an instance", e);
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException("reflector cannot access the constructor", e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ReflectorException("some exception occured in the constructor", t);
        }
    }

    public Object invoke(Method method, Object obj, Object ... args) {
        try {
            boolean accessible = method.isAccessible();
            method.setAccessible(true);
            Object returnValue = method.invoke(obj, args);
            method.setAccessible(accessible);
            return returnValue;
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException("reflector cannot invoke " + method.getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new ReflectorException("some exception occured in " + method.getName(), t);
        }
    }

    public Object invoke(String name, Object obj, Object ... args) {
        return this.invoke(this.getMethod(name, args), obj, args);
    }

    public Object getFieldValue(Field field, Object obj) {
        try {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            Object value = field.get(obj);
            field.setAccessible(accessible);
            return value;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException("reflector cannot get value from " + field.getName(), e);
        }
    }

    public Object getFieldValue(String name, Object obj) {
        return this.getFieldValue(this.getField(name), obj);
    }

    public final void setFieldValue(Field field, Object obj, Object value) {
        try {
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(accessible);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ReflectorException("reflector cannot set value to " + field.getName(), e);
        }
    }

    public void setFieldValue(String name, Object obj, Object value) {
        this.setFieldValue(this.getField(name), obj, value);
    }

    public <E extends Annotation> E getAnnotation(AnnotatedElement element, Class<E> annotationClass) {
        return element.getAnnotation(annotationClass);
    }

    public Annotation[] getAnnotations(AnnotatedElement element) {
        return element.getDeclaredAnnotations();
    }

    public Constructor<?> getConstructor(Class<?> ... parameterTypes) {
        if (this.constructors == null) {
            this.constructors = new ConstructorsCollection();
        }
        return this.constructors.find(parameterTypes);
    }

    public Constructor<?> getConstructor(Object ... initargs) {
        return this.getConstructor(Assignments.getParameterTypes(initargs));
    }

    public Constructor<?>[] getConstructors() {
        if (this.constructors == null) {
            this.constructors = new ConstructorsCollection();
        }
        return this.constructors.list().toArray(new Constructor[this.constructors.list().size()]);
    }

    public Method getMethod(String name, Class<?> ... parameterTypes) {
        if (this.methods == null) {
            this.methods = new MethodsCollection();
        }
        return this.methods.find(name, parameterTypes);
    }

    public Method getMethod(String name, Object ... args) {
        return this.getMethod(name, Assignments.getParameterTypes(args));
    }

    public Method[] getMethods() {
        if (this.methods == null) {
            this.methods = new MethodsCollection();
        }
        return this.methods.list().toArray(new Method[this.methods.list().size()]);
    }

    public Field getField(String name) {
        if (this.fields == null) {
            this.fields = new FieldsCollection();
        }
        return this.fields.find(name);
    }

    public Field[] getFields() {
        if (this.fields == null) {
            this.fields = new FieldsCollection();
        }
        return this.fields.list().toArray(new Field[this.fields.list().size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.constructors == null ? 0 : this.constructors.hashCode());
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Reflector other = (Reflector)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        if (this.constructors == null ? other.constructors != null : !this.constructors.equals(other.constructors)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        return !(this.methods == null ? other.methods != null : !this.methods.equals(other.methods));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorsCollection
    implements Iterable<Constructor<?>> {
        private Set<Constructor<?>> constructors;

        public ConstructorsCollection() {
            HashSet set = new HashSet();
            Constructor<?>[] constructorArray = Reflector.this.clazz.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> constructor = constructorArray[n2];
                set.add(constructor);
                ++n2;
            }
            this.constructors = Collections.unmodifiableSet(set);
        }

        public Constructor<?> find(Class<?> ... parameterTypes) {
            for (Constructor<?> constructor : this.constructors) {
                if (!Assignments.assign(constructor.getParameterTypes(), parameterTypes, constructor.isVarArgs())) continue;
                return constructor;
            }
            return null;
        }

        public List<Constructor<?>> list() {
            return Collections.unmodifiableList(new ArrayList(this.constructors));
        }

        @Override
        public Iterator<Constructor<?>> iterator() {
            return this.list().iterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.constructors == null ? 0 : this.constructors.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstructorsCollection other = (ConstructorsCollection)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.constructors == null ? other.constructors != null : !this.constructors.equals(other.constructors));
        }

        private Reflector getOuterType() {
            return Reflector.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FieldsCollection
    implements Iterable<Field> {
        private Map<String, Field> fields = new ConcurrentHashMap<String, Field>();

        public FieldsCollection() {
            Class declareClass = Reflector.this.clazz;
            while (declareClass != null) {
                Field[] fieldArray = Reflector.this.clazz.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    this.fields.put(field.getName(), field);
                    ++n2;
                }
                declareClass = declareClass.getSuperclass();
            }
            this.fields = Collections.unmodifiableMap(this.fields);
        }

        public Field find(String name) {
            return this.fields.get(name);
        }

        public List<Field> list() {
            ArrayList<Field> list = new ArrayList<Field>(this.fields.size());
            ArrayList<String> names = new ArrayList<String>(this.fields.keySet());
            Collections.sort(names);
            for (String name : names) {
                list.add(this.fields.get(name));
            }
            return Collections.unmodifiableList(list);
        }

        @Override
        public Iterator<Field> iterator() {
            return this.list().iterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldsCollection other = (FieldsCollection)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.fields == null ? other.fields != null : !this.fields.equals(other.fields));
        }

        private Reflector getOuterType() {
            return Reflector.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodsCollection
    implements Iterable<Method> {
        private Map<String, List<Method>> methods = new ConcurrentHashMap<String, List<Method>>();

        public MethodsCollection() {
            Class declareClass = Reflector.this.clazz;
            while (declareClass != null) {
                Method[] methodArray = declareClass.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    List<Object> methodsList;
                    Method method = methodArray[n2];
                    String name = method.getName();
                    if (!this.methods.containsKey(name)) {
                        methodsList = new ArrayList<Method>();
                        methodsList.add(method);
                        this.methods.put(name, methodsList);
                    } else {
                        methodsList = this.methods.get(name);
                        methodsList.add(method);
                        this.methods.put(name, methodsList);
                    }
                    ++n2;
                }
                declareClass = declareClass.getSuperclass();
            }
            this.methods = Collections.unmodifiableMap(this.methods);
        }

        public Method find(String name, Class<?> ... types) {
            if (this.methods.containsKey(name)) {
                for (Method method : this.methods.get(name)) {
                    if (!Assignments.assign(method.getParameterTypes(), types, method.isVarArgs())) continue;
                    return method;
                }
            }
            return null;
        }

        public List<Method> list() {
            ArrayList list = new ArrayList(this.methods.size());
            ArrayList<String> names = new ArrayList<String>(this.methods.keySet());
            Collections.sort(names);
            for (String name : names) {
                list.addAll(this.methods.get(name));
            }
            return Collections.unmodifiableList(list);
        }

        @Override
        public Iterator<Method> iterator() {
            return this.list().iterator();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.methods == null ? 0 : this.methods.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodsCollection other = (MethodsCollection)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.methods == null ? other.methods != null : !this.methods.equals(other.methods));
        }

        private Reflector getOuterType() {
            return Reflector.this;
        }
    }
}

