/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.calendar;

import java.util.Locale;

public class LocaleBuilder {
    private String language;
    private String country;
    private String variable;

    public Locale build() {
        if (this.language != null && this.language.length() > 0) {
            if (this.country != null && this.country.length() > 0) {
                if (this.variable != null && this.variable.length() > 0) {
                    return new Locale(this.language, this.country, this.variable);
                }
                return new Locale(this.language, this.country);
            }
            return new Locale(this.language);
        }
        return Locale.getDefault();
    }

    public LocaleBuilder language(String language) {
        this.language = language;
        return this;
    }

    public LocaleBuilder country(String country) {
        this.country = country;
        return this;
    }

    public LocaleBuilder variable(String variable) {
        this.variable = variable;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.language == null ? 0 : this.language.hashCode());
        result = 31 * result + (this.variable == null ? 0 : this.variable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocaleBuilder other = (LocaleBuilder)obj;
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        return !(this.variable == null ? other.variable != null : !this.variable.equals(other.variable));
    }

    public String toString() {
        return "LocaleBuilder [language=" + this.language + ", country=" + this.country + ", variable=" + this.variable + "]";
    }
}

