/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.ss;

import jp.coppermine.voyager.xlsmaker.enums.Alignment;
import jp.coppermine.voyager.xlsmaker.enums.Boldweight;
import jp.coppermine.voyager.xlsmaker.enums.BorderStyle;
import jp.coppermine.voyager.xlsmaker.enums.Color;
import jp.coppermine.voyager.xlsmaker.enums.FillPattern;
import jp.coppermine.voyager.xlsmaker.enums.TypeOffset;
import jp.coppermine.voyager.xlsmaker.enums.Underline;
import jp.coppermine.voyager.xlsmaker.enums.VerticalAlignment;
import jp.coppermine.voyager.xlsmaker.model.XFont;
import jp.coppermine.voyager.xlsmaker.model.XStyle;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSSheet;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSWorkbook;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;

public class SSResources {
    private Workbook workbook;

    SSResources(Workbook workbook) {
        this.workbook = workbook;
    }

    SSResources(SSSheet ssSheet) {
        this.workbook = ((SSWorkbook)ssSheet.getWorkbook()).getWorkbook();
    }

    Font createFont() {
        return this.workbook.createFont();
    }

    Font setFont(Font font, XFont xFont) {
        font.setFontName(xFont.getName());
        font.setFontHeight(xFont.getHeight());
        font.setColor(xFont.getColor().value());
        font.setBoldweight(xFont.getBoldweight().value());
        font.setItalic(xFont.isItalic());
        font.setStrikeout(xFont.isStrikeout());
        font.setTypeOffset(xFont.getTypeOffset().value());
        font.setUnderline(xFont.getUnderline().value());
        return font;
    }

    Font findFont(XFont xFont) {
        short index = 0;
        while (index < this.workbook.getNumberOfFonts()) {
            Font font = this.workbook.getFontAt(index);
            if (font.getFontName().intern() == xFont.getName().intern() && font.getFontHeight() == xFont.getHeight() && font.getColor() == xFont.getColor().value() && font.getBoldweight() == xFont.getBoldweight().value() && font.getItalic() == xFont.isItalic() && font.getStrikeout() == xFont.isStrikeout() && font.getTypeOffset() == xFont.getTypeOffset().value() && font.getUnderline() == xFont.getUnderline().value()) {
                return font;
            }
            index = (short)(index + 1);
        }
        return this.setFont(this.workbook.createFont(), xFont);
    }

    XFont getXFont(Font font) {
        return XFont.builder().name(font.getFontName()).height(font.getFontHeight()).color(Color.valueOf(font.getColor())).boldweight(Boldweight.valueOf(font.getBoldweight())).italic(font.getItalic()).strikeout(font.getStrikeout()).typeOffset(TypeOffset.valueOf(font.getTypeOffset())).underline(Underline.valueOf(font.getUnderline())).build();
    }

    CellStyle createCellStyle() {
        return this.workbook.createCellStyle();
    }

    CellStyle setCellStyle(short index, XStyle xStyle) {
        if (index < 0 || index >= this.workbook.getNumCellStyles()) {
            throw new IndexOutOfBoundsException("the valid index is from 0 to " + (this.workbook.getNumCellStyles() - 1));
        }
        CellStyle cellStyle = this.workbook.getCellStyleAt(index);
        if (xStyle.getDataFormatString() == null || xStyle.getDataFormatString().length() == 0) {
            cellStyle.setDataFormat(xStyle.getDataFormat());
        } else {
            cellStyle.setDataFormat(this.workbook.createDataFormat().getFormat(xStyle.getDataFormatString()));
        }
        cellStyle.setAlignment(xStyle.getAlignment().value());
        cellStyle.setVerticalAlignment(xStyle.getVerticalAlignment().value());
        cellStyle.setIndention(xStyle.getIndention());
        cellStyle.setRotation(xStyle.getRotation());
        cellStyle.setWrapText(xStyle.isWrapText());
        cellStyle.setFont(this.findFont(xStyle.getXFont()));
        cellStyle.setBorderTop(xStyle.getBorderTop().value());
        cellStyle.setBorderBottom(xStyle.getBorderBottom().value());
        cellStyle.setBorderLeft(xStyle.getBorderLeft().value());
        cellStyle.setBorderRight(xStyle.getBorderRight().value());
        cellStyle.setTopBorderColor(xStyle.getTopBorderColor().value());
        cellStyle.setBottomBorderColor(xStyle.getBottomBorderColor().value());
        cellStyle.setLeftBorderColor(xStyle.getLeftBorderColor().value());
        cellStyle.setRightBorderColor(xStyle.getRightBorderColor().value());
        cellStyle.setFillForegroundColor(xStyle.getFillForegroundColor().value());
        cellStyle.setFillBackgroundColor(xStyle.getFillBackgroundColor().value());
        cellStyle.setFillPattern(xStyle.getFillPattern().value());
        return cellStyle;
    }

    CellStyle findCellStyle(XStyle xStyle) {
        short index = 0;
        while (index < this.workbook.getNumCellStyles()) {
            CellStyle style = this.workbook.getCellStyleAt(index);
            if (!(xStyle.getDataFormatString() != null && xStyle.getDataFormatString().length() != 0 ? !xStyle.getDataFormatString().equals(style.getDataFormatString()) : xStyle.getDataFormat() != style.getDataFormat())) {
                if (xStyle.getAlignment().value() == style.getAlignment() && xStyle.getVerticalAlignment().value() == style.getVerticalAlignment() && xStyle.getIndention() == style.getIndention() && xStyle.getRotation() == style.getRotation() && xStyle.isWrapText() == style.getWrapText() && this.findFont(xStyle.getXFont()).getIndex() == style.getFontIndex() && xStyle.getBorderTop().value() == style.getBorderTop() && xStyle.getBorderBottom().value() == style.getBorderBottom() && xStyle.getBorderLeft().value() == style.getBorderLeft() && xStyle.getBorderRight().value() == style.getBorderRight() && xStyle.getTopBorderColor().value() == style.getTopBorderColor() && xStyle.getBottomBorderColor().value() == style.getBottomBorderColor() && xStyle.getLeftBorderColor().value() == style.getLeftBorderColor() && xStyle.getRightBorderColor().value() == style.getRightBorderColor() && xStyle.getFillForegroundColor().value() == style.getFillForegroundColor() && xStyle.getFillBackgroundColor().value() == style.getFillBackgroundColor() && xStyle.getFillPattern().value() == style.getFillPattern()) {
                    return style;
                }
            }
            index = (short)(index + 1);
        }
        return this.setCellStyle(this.workbook.createCellStyle().getIndex(), xStyle);
    }

    XStyle getXStyle(CellStyle cellStyle) {
        return XStyle.builder().dataFormat(cellStyle.getDataFormat()).dataFormat(cellStyle.getDataFormatString()).alignment(Alignment.valueOf(cellStyle.getAlignment())).verticalAlignment(VerticalAlignment.valueOf(cellStyle.getVerticalAlignment())).indention(cellStyle.getIndention()).rotation(cellStyle.getRotation()).wrapText(cellStyle.getWrapText()).font(this.getXFont(this.workbook.getFontAt(cellStyle.getFontIndex()))).borderTop(BorderStyle.valueOf(cellStyle.getBorderTop()), Color.valueOf(cellStyle.getTopBorderColor())).borderBottom(BorderStyle.valueOf(cellStyle.getBorderTop()), Color.valueOf(cellStyle.getBottomBorderColor())).borderLeft(BorderStyle.valueOf(cellStyle.getBorderTop()), Color.valueOf(cellStyle.getLeftBorderColor())).borderRight(BorderStyle.valueOf(cellStyle.getBorderTop()), Color.valueOf(cellStyle.getRightBorderColor())).foreground(Color.valueOf(cellStyle.getFillForegroundColor())).background(Color.valueOf(cellStyle.getFillBackgroundColor())).pattern(FillPattern.valueOf(cellStyle.getFillPattern())).build();
    }
}

