/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.model.impl.ss;

import java.util.EnumMap;
import java.util.Map;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.RangeProvider;
import jp.coppermine.voyager.xlsmaker.coord.RangeUnit;
import jp.coppermine.voyager.xlsmaker.enums.BorderStyle;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSAssignment;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSResources;
import jp.coppermine.voyager.xlsmaker.model.impl.ss.SSSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSRange
implements XRange {
    private SSSheet ssSheet;
    private SSResources resources;
    private RangeUnit rangeUnit;
    private XStyle xStyle;

    SSRange(SSSheet ssSheet, RangeProvider rangeProvider) {
        this.ssSheet = ssSheet;
        this.rangeUnit = rangeProvider.toRangeUnit();
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        Sheet sheet = ssSheet.getSheet();
        int r = first.row();
        while (r <= last.row()) {
            Row row = sheet.getRow(r) == null ? sheet.createRow(r) : sheet.getRow(r);
            int c = first.column();
            while (c <= last.column()) {
                if (row.getCell(c) == null) {
                    row.createCell(c);
                }
                ++c;
            }
            ++r;
        }
        this.resources = new SSResources(ssSheet);
        this.xStyle = this.resources.getXStyle(sheet.getRow(first.row()).getCell(first.column()).getCellStyle());
    }

    @Override
    public <T> T getValue(Class<T> clazz) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        Cell cell = this.ssSheet.getSheet().getRow(first.row()).getCell(first.column());
        return SSAssignment.getValue(cell, clazz);
    }

    @Override
    public void setValue(Object value) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        Cell cell = this.ssSheet.getSheet().getRow(first.row()).getCell(first.column());
        SSAssignment.setValue(cell, value);
    }

    @Override
    public String getStringValue() {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        Cell cell = this.ssSheet.getSheet().getRow(first.row()).getCell(first.column());
        return cell.getStringCellValue();
    }

    @Override
    public String getFormula() {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        Sheet sheet = this.ssSheet.getSheet();
        Cell cell = sheet.getRow(first.row()).getCell(first.column());
        if (cell.getCellType() == 2) {
            return cell.getCellFormula();
        }
        return null;
    }

    @Override
    public void setFormula(String formula) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        Sheet sheet = this.ssSheet.getSheet();
        Cell cell = sheet.getRow(first.row()).getCell(first.column());
        cell.setCellType(2);
        cell.setCellFormula(formula);
    }

    @Override
    public XStyle getStyle() {
        return this.xStyle;
    }

    @Override
    public void setStyle(XStyle style) {
        this.xStyle = style;
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        int rows = last.row() - first.row() + 1;
        int columns = last.column() - first.column() + 1;
        Sheet sheet = this.ssSheet.getSheet();
        Map<Area, XStyle> styles = this.expandStyle(this.xStyle);
        if (rows == 1) {
            if (columns == 1) {
                Cell cell = sheet.getRow(first.row()).getCell(first.column());
                cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
            } else if (columns == 2) {
                Cell firstCell = sheet.getRow(first.row()).getCell(first.column());
                firstCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                Cell lastCell = sheet.getRow(first.row()).getCell(last.column());
                lastCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
            } else {
                Cell firstCell = sheet.getRow(first.row()).getCell(first.column());
                firstCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                int c = first.column() + 1;
                while (c < last.column()) {
                    Cell cell = sheet.getRow(first.row()).getCell(c);
                    cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
                    ++c;
                }
                Cell lastCell = sheet.getRow(first.row()).getCell(last.column());
                lastCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
            }
        } else if (rows == 2) {
            if (columns == 1) {
                Cell topCell = sheet.getRow(first.row()).getCell(first.column());
                topCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
                Cell bottomCell = sheet.getRow(last.row()).getCell(first.column());
                bottomCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
            } else if (columns == 2) {
                Cell topLeftCell = sheet.getRow(first.row()).getCell(first.column());
                topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
                Cell topRightCell = sheet.getRow(first.row()).getCell(last.column());
                topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
                Cell bottomRightCell = sheet.getRow(last.row()).getCell(last.column());
                bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
                Cell bottomLeftCell = sheet.getRow(last.row()).getCell(first.column());
                bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
            } else {
                Cell topLeftCell = sheet.getRow(first.row()).getCell(first.column());
                topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
                Cell topRightCell = sheet.getRow(first.row()).getCell(last.column());
                topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
                Cell bottomRightCell = sheet.getRow(last.row()).getCell(last.column());
                bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
                Cell bottomLeftCell = sheet.getRow(last.row()).getCell(first.column());
                bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
                int c = first.column() + 1;
                while (c < last.column()) {
                    Cell topCell = sheet.getRow(first.row()).getCell(c);
                    topCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
                    Cell bottomCell = sheet.getRow(last.row()).getCell(c);
                    bottomCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
                    ++c;
                }
            }
        } else if (columns == 1) {
            Cell topCell = sheet.getRow(first.row()).getCell(first.column());
            topCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
            int r = first.row() + 1;
            while (r < last.row()) {
                Cell innerCell = sheet.getRow(r).getCell(first.column());
                innerCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
                ++r;
            }
            Cell bottomCell = sheet.getRow(last.row()).getCell(first.column());
            bottomCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
        } else if (columns == 2) {
            Cell topLeftCell = sheet.getRow(first.row()).getCell(first.column());
            topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
            Cell topRightCell = sheet.getRow(first.row()).getCell(last.column());
            topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
            int r = first.row() + 1;
            while (r < last.row()) {
                Cell leftCell = sheet.getRow(r).getCell(first.column());
                leftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                Cell rightCell = sheet.getRow(r).getCell(last.column());
                rightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
                ++r;
            }
            Cell bottomRightCell = sheet.getRow(last.row()).getCell(last.column());
            bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
            Cell bottomLeftCell = sheet.getRow(last.row()).getCell(first.column());
            bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
        } else {
            Cell topLeftCell = sheet.getRow(first.row()).getCell(first.column());
            topLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
            Cell topRightCell = sheet.getRow(first.row()).getCell(last.column());
            topRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
            Cell bottomRightCell = sheet.getRow(last.row()).getCell(last.column());
            bottomRightCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
            Cell bottomLeftCell = sheet.getRow(last.row()).getCell(first.column());
            bottomLeftCell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
            int r = first.row();
            while (r <= last.row()) {
                int c = first.column();
                while (c <= last.column()) {
                    Cell cell = sheet.getRow(r).getCell(c);
                    if (r == first.row()) {
                        if (c == first.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_LEFT)));
                        } else if (c == last.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP_RIGHT)));
                        } else {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.TOP)));
                        }
                    } else if (r == last.row()) {
                        if (c == first.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_LEFT)));
                        } else if (c == last.column()) {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM_RIGHT)));
                        } else {
                            cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.BOTTOM)));
                        }
                    } else if (c == first.column()) {
                        cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.LEFT)));
                    } else if (c == last.column()) {
                        cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.RIGHT)));
                    } else {
                        cell.setCellStyle(this.resources.findCellStyle(styles.get((Object)Area.INNER)));
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    @Override
    public XSheet getSheet() {
        return this.ssSheet;
    }

    @Override
    public CellUnit getFirstCellUnit() {
        return this.rangeUnit.getFirstCellUnit();
    }

    @Override
    public CellUnit getLastCellUnit() {
        return this.rangeUnit.getLastCellUnit();
    }

    @Override
    public RangeUnit toRangeUnit() {
        return this.rangeUnit;
    }

    @Override
    public boolean isMerged() {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        CellRangeAddress cellRangeAddress = new CellRangeAddress(first.row(), last.row(), first.column(), last.column());
        Sheet sheet = this.ssSheet.getSheet();
        int index = 0;
        while (index < sheet.getNumMergedRegions()) {
            if (cellRangeAddress == sheet.getMergedRegion(index)) {
                return true;
            }
            ++index;
        }
        return false;
    }

    @Override
    public void setMerged(boolean merged) {
        CellUnit first = this.rangeUnit.getFirstCellUnit();
        CellUnit last = this.rangeUnit.getLastCellUnit();
        CellRangeAddress cellRangeAddress = new CellRangeAddress(first.row(), last.row(), first.column(), last.column());
        Sheet sheet = this.ssSheet.getSheet();
        if (merged) {
            sheet.addMergedRegion(cellRangeAddress);
        } else {
            int index = 0;
            while (index < sheet.getNumMergedRegions()) {
                if (cellRangeAddress == sheet.getMergedRegion(index)) {
                    sheet.removeMergedRegion(index);
                    return;
                }
                ++index;
            }
        }
    }

    Map<Area, XStyle> expandStyle(XStyle xStyle) {
        EnumMap<Area, XStyle> map = new EnumMap<Area, XStyle>(Area.class);
        int rows = this.rangeUnit.getLastCellUnit().row() - this.rangeUnit.getFirstCellUnit().row() + 1;
        int columns = this.rangeUnit.getLastCellUnit().column() - this.rangeUnit.getFirstCellUnit().column() + 1;
        if (rows == 1) {
            if (columns == 1) {
                map.put(Area.INNER, xStyle);
                return map;
            }
            if (columns == 2) {
                map.put(Area.LEFT, XStyle.builder(xStyle).borderRight(BorderStyle.NONE).build());
                map.put(Area.RIGHT, XStyle.builder(xStyle).borderLeft(BorderStyle.NONE).build());
            } else {
                map.put(Area.LEFT, XStyle.builder(xStyle).borderRight(BorderStyle.NONE).build());
                map.put(Area.INNER, XStyle.builder(xStyle).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.RIGHT, XStyle.builder(xStyle).borderLeft(BorderStyle.NONE).build());
            }
        } else if (rows == 2) {
            if (columns == 1) {
                map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).build());
                map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).build());
            } else if (columns == 2) {
                map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            } else {
                map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
                map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            }
        } else if (columns == 1) {
            map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).build());
            map.put(Area.INNER, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderBottom(BorderStyle.NONE).build());
            map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).build());
        } else if (columns == 2) {
            map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
        } else {
            map.put(Area.LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP_LEFT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.TOP_RIGHT, XStyle.builder(xStyle).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_LEFT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).borderRight(BorderStyle.NONE).build());
            map.put(Area.BOTTOM_RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.RIGHT, XStyle.builder(xStyle).borderTop(BorderStyle.NONE).borderBottom(BorderStyle.NONE).borderLeft(BorderStyle.NONE).build());
            map.put(Area.INNER, XStyle.builder(xStyle).border(BorderStyle.NONE).build());
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Area {
        TOP_LEFT,
        TOP,
        TOP_RIGHT,
        LEFT,
        INNER,
        RIGHT,
        BOTTOM_LEFT,
        BOTTOM,
        BOTTOM_RIGHT;

    }
}

