/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.coord;

import java.io.Serializable;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;

public final class RowUnit
implements RowProvider,
Serializable {
    private static final long serialVersionUID = -455346321431247674L;
    public static final RowUnit ORIGIN = new RowUnit(0);
    private final int row;

    private RowUnit(int row) {
        this.row = row;
    }

    public static final RowUnit at(int row) {
        return new RowUnit(row);
    }

    public static final RowUnit from(RowProvider rowProvider) {
        return new RowUnit(rowProvider.row());
    }

    public static final RowUnit of(String address) {
        address = address.replaceFirst("^([A-Za-z]+)?(\\d+)$", "$2");
        return new RowUnit(Integer.parseInt(address) - 1);
    }

    public int row() {
        return this.row;
    }

    public RowUnit shift(int rows) {
        return new RowUnit(this.row + rows);
    }

    public RowUnit shift(RowProvider rowProvider) {
        return new RowUnit(this.row + rowProvider.row());
    }

    public String toString() {
        return Integer.toString(this.row + 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RowUnit other = (RowUnit)obj;
        return this.row == other.row;
    }
}

