/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.coord;

import java.io.Serializable;
import jp.coppermine.voyager.xlsmaker.coord.CellProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;

public final class CellUnit
implements CellProvider,
Serializable {
    private static final long serialVersionUID = -6026230564589221108L;
    private final int row;
    private final int column;

    private CellUnit(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public static CellUnit at(int row, int column) {
        return new CellUnit(row, column);
    }

    public static CellUnit from(RowProvider rowProvider, ColumnProvider columnProvider) {
        return new CellUnit(rowProvider.row(), columnProvider.column());
    }

    public static CellUnit of(String address) {
        return new CellUnit(RowUnit.of(address).row(), ColumnUnit.of(address).column());
    }

    public int row() {
        return this.row;
    }

    public int column() {
        return this.column;
    }

    public CellUnit shift(int rows, int columns) {
        return new CellUnit(this.row + rows, this.column + columns);
    }

    public CellUnit shift(RowProvider rowProvider, ColumnProvider columnProvider) {
        return new CellUnit(this.row + rowProvider.row(), this.column + columnProvider.column());
    }

    public CellUnit toCellUnit() {
        return this;
    }

    public String toString() {
        return String.valueOf(ColumnUnit.at(this.column).toString()) + RowUnit.at(this.row).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.row;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CellUnit other = (CellUnit)obj;
        if (this.column != other.column) {
            return false;
        }
        return this.row == other.row;
    }
}

