/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    public static final String EMPTY = "".intern();
    public static final String[] ZERO = new String[0];

    private Strings() {
    }

    public static final String join(String delimiter, CharSequence ... strings) {
        if (strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        CharSequence[] charSequenceArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence csq = charSequenceArray[n2];
            sb.append(delimiter).append(csq);
            ++n2;
        }
        return sb.length() > 0 ? sb.delete(0, delimiter.length()).toString() : sb.toString();
    }

    public static String join(Delimiter delimiter, CharSequence ... strings) {
        return Strings.join(delimiter.toString(), strings);
    }

    public static String concat(CharSequence ... strings) {
        return Strings.join(Delimiter.NONE, strings);
    }

    public static String[] divide(CharSequence string, int length) {
        StringBuilder buffer = new StringBuilder(string);
        ArrayList<String> chunk = new ArrayList<String>();
        while (buffer.length() >= length) {
            chunk.add(buffer.substring(0, length));
            buffer.delete(0, length);
        }
        if (buffer.length() > 0) {
            chunk.add(buffer.toString());
        }
        return chunk.toArray(new String[chunk.size()]);
    }

    public static int countOf(CharSequence string, int ch) {
        return Strings.countOf(string, Character.toString((char)ch));
    }

    public static int countOf(CharSequence string, String str) {
        String s = string.toString();
        int count = 0;
        int index = -1;
        while ((index = s.indexOf(str, index + 1)) >= 0) {
            ++count;
        }
        return count;
    }

    public static String toInitialUpperCase(CharSequence str) {
        if (str.length() == 0) {
            return "";
        }
        String s = str.toString();
        if (str.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static String toInitialLowerCase(CharSequence str) {
        if (str.length() == 0) {
            return "";
        }
        String s = str.toString();
        if (str.length() == 1) {
            return s.toLowerCase();
        }
        return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
    }

    public static String toCamelCase(CharSequence str) {
        String[] words = str.toString().split("_+", -1);
        if (words.length == 0) {
            return "";
        }
        StringBuilder camel = new StringBuilder();
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            if (word.length() > 0) {
                camel.append(word.substring(0, 1).toUpperCase());
                if (word.length() > 1) {
                    camel.append(word.substring(1).toLowerCase());
                }
            }
            ++n2;
        }
        return camel.toString();
    }

    public static String toUnderscoreDelimited(CharSequence str) {
        Matcher matcher = Pattern.compile("(?<=^|[a-z_0-9])([A-Z][a-z_0-9]+)").matcher(str);
        ArrayList<String> word = new ArrayList<String>();
        while (matcher.find()) {
            word.add(matcher.group().toUpperCase());
        }
        return Strings.join(Delimiter.UNDERSCORE, (CharSequence[])word.toArray(new String[word.size()]));
    }

    public static boolean equalsAll(CharSequence ... str) {
        HashSet<String> set = new HashSet<String>();
        CharSequence[] charSequenceArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence s = charSequenceArray[n2];
            if (s != null) {
                set.add(s.toString());
            }
            ++n2;
        }
        return set.size() == 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Delimiter {
        NONE(""),
        TAB("\t"),
        NEWLINE("\n"),
        COMMA(","),
        PERIOD("."),
        DOT("."),
        COLON(":"),
        SEMICOLON(";"),
        AMPERSAND("&"),
        PLUS("+"),
        MINUS("-"),
        HYPHEN("-"),
        UNDERLINE("_"),
        UNDERSCORE("_"),
        EXCLAMATION("!"),
        QUESTION("?"),
        VERTICAL_LINE("|"),
        PIPE("|"),
        SLASH("/"),
        BACKSLASH("\\");

        String pattern;

        private Delimiter(String pattern) {
            this.pattern = pattern;
        }

        public String toString() {
            return this.pattern;
        }
    }
}

