/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.calendar;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateBuilder {
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int millisecond;
    private TimeZone zone = TimeZone.getDefault();
    private Locale aLocale = Locale.getDefault();

    public DateBuilder timeZone(TimeZone zone) {
        this.zone = zone;
        return this;
    }

    public DateBuilder locale(Locale aLocale) {
        this.aLocale = aLocale;
        return this;
    }

    public DateBuilder now() {
        Calendar cal = Calendar.getInstance(this.zone, this.aLocale);
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.millisecond = cal.get(14);
        return this;
    }

    public DateBuilder today() {
        Calendar cal = Calendar.getInstance(this.zone, this.aLocale);
        this.year = cal.get(1);
        this.month = cal.get(2) + 1;
        this.day = cal.get(5);
        this.hour = 0;
        this.minute = 0;
        this.second = 0;
        this.millisecond = 0;
        return this;
    }

    public DateBuilder year(int year) {
        this.year = year;
        return this;
    }

    public DateBuilder month(int month) {
        this.month = month;
        return this;
    }

    public DateBuilder day(int day) {
        this.day = day;
        return this;
    }

    public DateBuilder hour(int hour) {
        this.hour = hour;
        return this;
    }

    public DateBuilder minute(int minute) {
        this.minute = minute;
        return this;
    }

    public DateBuilder second(int second) {
        this.second = second;
        return this;
    }

    public DateBuilder millisecond(int millisecond) {
        this.millisecond = millisecond;
        return this;
    }

    public Date build() {
        Calendar cal = Calendar.getInstance(this.zone, this.aLocale);
        cal.set(1, this.year);
        cal.set(2, this.month - 1);
        cal.set(5, this.day);
        cal.set(11, this.hour);
        cal.set(12, this.minute);
        cal.set(13, this.second);
        cal.set(14, this.millisecond);
        return cal.getTime();
    }
}

