/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.beans.collection.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import jp.coppermine.voyager.reflect.Reflector;
import jp.coppermine.voyager.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyMembers {
    public static final Pattern ACCESSOR_NAME_PATTERN = Pattern.compile("^(?!getClass\\b)(get|is|set)([A-Z]\\w*)$");

    private PropertyMembers() {
    }

    public static boolean hasDefaultConstructor(Class<?> clazz) {
        Reflector reflector = Reflector.getReflector(clazz);
        Constructor<?> constructor = reflector.getConstructor(new Class[0]);
        return constructor != null && (Modifier.isPublic(constructor.getModifiers()) || constructor.getModifiers() == 0);
    }

    public static boolean isValid(Method method) {
        return method != null && !Modifier.isStatic(method.getModifiers()) && !Modifier.isFinal(method.getModifiers()) && (PropertyMembers.isGetter(method) || PropertyMembers.isSetter(method));
    }

    public static boolean isValid(Field field) {
        return field != null && !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    }

    public static boolean isGetter(Method method) {
        if (method == null) {
            return false;
        }
        Class<?> type = method.getReturnType();
        if (type == Void.TYPE || type == Void.class) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        String prefix = ACCESSOR_NAME_PATTERN.matcher(method.getName()).replaceFirst("$1");
        if ((type == Boolean.TYPE || type == Boolean.class) && "is".equals(prefix)) {
            return true;
        }
        return "get".equals(prefix);
    }

    public static boolean isSetter(Method method) {
        if (method == null) {
            return false;
        }
        Class<?> type = method.getReturnType();
        if (type != Void.TYPE && type != Void.class) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        String prefix = ACCESSOR_NAME_PATTERN.matcher(method.getName()).replaceFirst("$1");
        return "set".equals(prefix);
    }

    public static Class<?> getType(Method method) {
        if (method == null) {
            throw new NullPointerException();
        }
        if (PropertyMembers.isGetter(method)) {
            return method.getReturnType();
        }
        if (PropertyMembers.isSetter(method)) {
            return method.getParameterTypes()[0];
        }
        throw new IllegalArgumentException(String.valueOf(method.getName()) + " is invalid getter/setter");
    }

    public static Class<?> getType(Field field) {
        if (field == null) {
            throw new NullPointerException();
        }
        return field.getType();
    }

    public static String getName(Method method) {
        return method != null ? Strings.toInitialLowerCase(ACCESSOR_NAME_PATTERN.matcher(method.getName()).replaceFirst("$2")) : null;
    }

    public static String getName(Field field) {
        return field != null ? field.getName() : null;
    }
}

