/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.beans;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import jp.coppermine.voyager.beans.PropertyAccessException;
import jp.coppermine.voyager.beans.collection.Property;
import jp.coppermine.voyager.beans.collection.impl.PropertyCollection;
import jp.coppermine.voyager.beans.collection.impl.PropertyMembers;
import jp.coppermine.voyager.reflect.Reflector;
import jp.coppermine.voyager.reflect.ReflectorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWrapper {
    private final Reflector reflector;
    private Object obj;
    private final PropertyCollection propertyCollection;

    public BeanWrapper(Class<?> clazz) {
        this(clazz, PropertyCollection.getBasic(clazz));
    }

    public BeanWrapper(Object obj) {
        this(obj.getClass(), PropertyCollection.getBasic(obj.getClass()));
        this.obj = obj;
    }

    protected BeanWrapper(Class<?> clazz, PropertyCollection propertyCollection) {
        if (!PropertyMembers.hasDefaultConstructor(clazz)) {
            throw new PropertyAccessException("the default constructor is not found");
        }
        this.reflector = Reflector.getReflector(clazz);
        this.propertyCollection = propertyCollection;
    }

    protected BeanWrapper(BeanWrapper bean) {
        this.reflector = bean.reflector;
        this.propertyCollection = bean.propertyCollection;
        this.obj = bean.obj;
    }

    public static BeanWrapper getWrapper(Class<?> clazz) {
        return new BeanWrapper(clazz, PropertyCollection.getBasic(clazz));
    }

    public static BeanWrapper getWrapper(Object obj) {
        return new BeanWrapper(obj.getClass(), PropertyCollection.getBasic(obj.getClass())).wrap(obj);
    }

    public static BeanWrapper getAdvancedWrapper(Class<?> clazz) {
        return new BeanWrapper(clazz, PropertyCollection.getAdvanced(clazz));
    }

    public static BeanWrapper getAdvancedWrapper(Object obj) {
        return new BeanWrapper(obj.getClass(), PropertyCollection.getAdvanced(obj.getClass())).wrap(obj);
    }

    public BeanWrapper wrap(Object obj) {
        this.obj = obj;
        return this;
    }

    public <T> T getObject(Class<T> clazz) {
        return clazz.cast(this.obj);
    }

    public Class<?> getType() {
        return this.reflector.getTarget();
    }

    protected PropertyCollection getPropertyCollection() {
        return this.propertyCollection;
    }

    public <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.cast(this.reflector.newInstance(new Object[0]));
        }
        catch (ReflectorException e) {
            throw new PropertyAccessException("instantiation failure");
        }
    }

    public Set<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this.propertyCollection.getProperyNames());
        Collections.sort(names);
        return new CopyOnWriteArraySet<String>(names);
    }

    public <E> E getProperty(String name, Class<E> clazz) {
        return clazz.cast(this.getProperty(name));
    }

    public Object getProperty(String name) {
        Property property = this.getPropertyCollection().getProperty(name);
        return property.getValue(this.obj);
    }

    public void setProperty(String name, Object value) {
        Property property = this.getPropertyCollection().getProperty(name);
        property.setValue(this.obj, value);
    }

    public Class<?> getType(String name) {
        return this.propertyCollection.getProperty(name).getType();
    }

    public <E extends Annotation> E getAnnotation(String name, Class<E> annotationClass) {
        return this.propertyCollection.getProperty(name).getAnnotation(annotationClass);
    }

    public <E extends Annotation> boolean isAnnotationPresent(String name, Class<E> annotationClass) {
        return this.getAnnotation(name, annotationClass) != null;
    }

    public <E extends Annotation> E getTypeAnnotation(Class<E> annotationClass) {
        return this.reflector.getAnnotation(this.reflector.getTarget(), annotationClass);
    }
}

