/***************************************************************************
                          wvoxbase.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  17:14:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////////////

#include <qlabel.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qscrollview.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "wvoxbase.h"
#include "wnamedialog.h"
#include "cvoxstormglobal.h"

/////////////////////////////////////////////////////////////////////////////

WVoxBase::WVoxBase(QWidget *WidgetParent, const char *cName)
  : QVBox(WidgetParent, cName)
{
  nTimerIDProceed = 0;
  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////

WVoxBase::WVoxBase(
      const QDomNode& nodBase,
      QWidget*        WidgetParent,
      const char*     cName)
  : QVBox(WidgetParent, cName)
{
  nTimerIDProceed = 0;
  setupWidgets();
  addTracks(nodBase);
}

/////////////////////////////////////////////////////////////////////////////

WVoxBase::~WVoxBase()
{
  killTimers();  // kill all timers

  if (vVoxTracks.empty() ) {
    return;
  }

  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();
  while ( it != vVoxTracks.end() ) {
    delete (*it);
    (*it) = NULL;
    it++;
  }

  vVoxTracks.clear();
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::addTrack(const QString& strDeviceIn, const QString& strDeviceOut)
{
  WNameDialog nameDialog(this);

  nameDialog.setValidChars(CVoxStormGlobal::ValidCharsTrack);

  if ( nameDialog.exec() == QDialog::Accepted ) {
    QString strTrackName = nameDialog.getNameFromDialog();
    
    if ( queryExistingTrackName(strTrackName)) { // already exsists
      QString strMessage = i18n("Track name : ");
      strMessage = "\"" + strTrackName + "\"\n";
      strMessage += i18n("The name is already usiing in other track.\n"
                         "Failed in adding track.");
      KMessageBox::sorry(this, strMessage);
      return;

    } else if ( !CVoxStormGlobal::isValidTrackName(strTrackName) ) {
      QString strMessage = 
                QString(i18n("The name \"%1\" cannot be used for "
                     "track name.\nFailed in adding track.").arg(strTrackName));
      KMessageBox::sorry(this, strMessage);
      return;
    } else {
      addTrack(strTrackName, strDeviceIn, strDeviceOut);
    }
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::addTrack(
            const QString& strTrackName, 
            const QString& strDeviceIn,
            const QString& strDeviceOut)
{
  WVoxTrack *VoxTrackNew = new WVoxTrack(
                                  strTrackName,
                                  strDeviceIn,
                                  strDeviceOut,
                                  timeMaxSessionLength, 
                                  VBoxTracks);

  SignalMapperPlayback->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(playbackDeviceChanged(const QString&)),
          SignalMapperPlayback, SLOT(map()));

  SignalMapperRecording->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(recordingDeviceChanged(const QString&)),
          SignalMapperRecording, SLOT(map()));

  SignalMapperRemove->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(removed()), SignalMapperRemove, SLOT(map()));

  SignalMapperFileName->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(fileNameChanged(const QString&)),
          SignalMapperFileName, SLOT(map()));

  SignalMapperLevel->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(levelChanged(int)), SignalMapperLevel, SLOT(map()));

  SignalMapperPan->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(panChanged(int)), SignalMapperPan, SLOT(map()));

  SignalMapperMute->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(muteToggled(bool)), SignalMapperMute, SLOT(map()));

  SignalMapperRec->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(recToggled(bool)), SignalMapperRec, SLOT(map()));

  SignalMapperStartPosition->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(startPositionChanged(const QTime&)),
          SignalMapperStartPosition, SLOT(map()));

  SignalMapperOffset->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(offsetChanged(const QTime&)),
          SignalMapperOffset, SLOT(map()));

  SignalMapperLength->setMapping(VoxTrackNew, strTrackName);
  connect(VoxTrackNew, SIGNAL(lengthChanged(const QTime&)), 
          SignalMapperLength, SLOT(map()));

  connect(VoxTrackNew, SIGNAL(locatorScrolled(QObject*, int)), 
          this, SLOT(slotSetScrollToAll(QObject*, int)));

  vVoxTracks.push_back(VoxTrackNew);
  VoxTrackNew->show();
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::addTracks(const QDomNode& nodTracks)
{
  if ( nodTracks.isNull() ) {
    return;
  }

  QDomNodeList nolTracks = nodTracks.childNodes();
  int i;
  int nCount = nolTracks.count();
  for ( i = 0; i < nCount; i++ ) {
    WVoxTrack *VoxTrackNew = new WVoxTrack(
                                   nolTracks.item(i), 
                                   timeMaxSessionLength, 
                                   VBoxTracks);
    QString strTrackName = VoxTrackNew->name();

    SignalMapperPlayback->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(playbackDeviceChanged(const QString&)),
            SignalMapperPlayback, SLOT(map()));

    SignalMapperRecording->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(recordingDeviceChanged(const QString&)),
            SignalMapperRecording, SLOT(map()));

    SignalMapperRemove->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(removed()), SignalMapperRemove, SLOT(map()));

    SignalMapperFileName->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(fileNameChanged(const QString&)), 
            SignalMapperFileName, SLOT(map()));

    SignalMapperLevel->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(levelChanged(int)), SignalMapperLevel, SLOT(map()));

    SignalMapperPan->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(panChanged(int)), SignalMapperPan, SLOT(map()));

    SignalMapperMute->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(muteToggled(bool)), SignalMapperMute, SLOT(map()));

    SignalMapperRec->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(recToggled(bool)), SignalMapperRec, SLOT(map()));

    SignalMapperStartPosition->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(startPositionChanged(const QTime&)),
            SignalMapperStartPosition, SLOT(map()));

    SignalMapperOffset->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(offsetChanged(const QTime&)),
            SignalMapperOffset, SLOT(map()));

    SignalMapperLength->setMapping(VoxTrackNew, strTrackName);
    connect(VoxTrackNew, SIGNAL(lengthChanged(const QTime&)),
            SignalMapperLength, SLOT(map()));

    connect(VoxTrackNew, SIGNAL(locatorScrolled(QObject*, int)), 
            this, SLOT(slotSetScrollToAll(QObject*, int)));

    VoxTrackNew->setMaxSessionLength(timeMaxSessionLength);

    vVoxTracks.push_back(VoxTrackNew);
    VoxTrackNew->show();
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::clearTracks()
{
  if ( vVoxTracks.empty() ) {
    return;
  }

  int i, nTrack;

  nTrack = vVoxTracks.size();
  for ( i = 0; i < nTrack; i++ ) {
    SignalMapperPlayback->removeMappings(vVoxTracks[i]);
    SignalMapperRecording->removeMappings(vVoxTracks[i]);
    SignalMapperRemove->removeMappings(vVoxTracks[i]);
    SignalMapperFileName->removeMappings(vVoxTracks[i]);
    SignalMapperLevel->removeMappings(vVoxTracks[i]);
    SignalMapperPan->removeMappings(vVoxTracks[i]);
    SignalMapperMute->removeMappings(vVoxTracks[i]);
    SignalMapperRec->removeMappings(vVoxTracks[i]);
    SignalMapperStartPosition->removeMappings(vVoxTracks[i]);
    SignalMapperOffset->removeMappings(vVoxTracks[i]);
    SignalMapperLength->removeMappings(vVoxTracks[i]);

    delete vVoxTracks[i];
    vVoxTracks[i] = NULL;
  }
  if ( nTrack != 0 ) {
    vVoxTracks.clear();
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::removeTrack()
{
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::removeTrack(const QString& strTrackName)
{
  int nID;

  if ( (nID = getIndexByName(strTrackName)) == -1 ) {  // not found
    return;
  }

  QValueVector<WVoxTrack*> vVoxTracksTmp;
  int i, nTrack;
  
  nTrack = vVoxTracks.size();
  for ( i = 0; i < nTrack; i++ ) {
    if ( i == nID ) {  // subject track
      SignalMapperPlayback->removeMappings(vVoxTracks[i]);
      SignalMapperRecording->removeMappings(vVoxTracks[i]);
      SignalMapperRemove->removeMappings(vVoxTracks[i]);
      SignalMapperFileName->removeMappings(vVoxTracks[i]);
      SignalMapperLevel->removeMappings(vVoxTracks[i]);
      SignalMapperPan->removeMappings(vVoxTracks[i]);
      SignalMapperMute->removeMappings(vVoxTracks[i]);
      SignalMapperRec->removeMappings(vVoxTracks[i]);
      SignalMapperStartPosition->removeMappings(vVoxTracks[i]);
      SignalMapperOffset->removeMappings(vVoxTracks[i]);
      SignalMapperLength->removeMappings(vVoxTracks[i]);
      delete vVoxTracks[i];
    } else {
      vVoxTracksTmp.push_back(vVoxTracks[i]);
    }
  }

  vVoxTracks.clear();
  nTrack--;
  for ( i = 0; i < nTrack; i++ ) {
    vVoxTracks.push_back(vVoxTracksTmp[i]);
  }
  vVoxTracksTmp.clear();
}

/////////////////////////////////////////////////////////////////////////////

int
WVoxBase::getTrackCount() const
{
  return vVoxTracks.size();
}

/////////////////////////////////////////////////////////////////////////////

CTrackInf 
WVoxBase::getTrackInf(int nID) const
{
  CTrackInf TrackInfReturn;
  if ( (0 > nID) || ((int)vVoxTracks.size() <= nID) ) {
    return TrackInfReturn;
  }

  return vVoxTracks[nID]->stateInTrackInf();
}

/////////////////////////////////////////////////////////////////////////////

CTrackInf
WVoxBase::getTrackInf(const QString& strTrackName) const
{
  return getTrackInf(getIndexByName(strTrackName));
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::setupWidgets()
{
  setFrameStyle(QFrame::Box | QFrame::Sunken);
  setMinimumWidth(512);
  setMinimumHeight(400);

  SignalMapperPlayback = new QSignalMapper(this);
  connect(SignalMapperPlayback, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangePlaybackDevice(const QString&)));

  SignalMapperRecording = new QSignalMapper(this);
  connect(SignalMapperRecording, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangeRecordingDevice(const QString&)));

  SignalMapperRemove = new QSignalMapper(this);
  connect(SignalMapperRemove, SIGNAL(mapped(const QString&)),
          this, SLOT(slotRemove(const QString&)));

  SignalMapperFileName = new QSignalMapper(this);
  connect(SignalMapperFileName, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangeFileName(const QString&)));

  SignalMapperLevel = new QSignalMapper(this);
  connect(SignalMapperLevel, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangeLevel(const QString&)));

  SignalMapperPan = new QSignalMapper(this);
  connect(SignalMapperPan, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangePan(const QString&)));

  SignalMapperMute = new QSignalMapper(this);
  connect(SignalMapperMute, SIGNAL(mapped(const QString&)),
          this, SLOT(slotToggleMute(const QString&)));

  SignalMapperRec = new QSignalMapper(this);
  connect(SignalMapperRec, SIGNAL(mapped(const QString&)),
          this, SLOT(slotToggleRec(const QString&)));

  SignalMapperStartPosition = new QSignalMapper(this);
  connect(SignalMapperStartPosition, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangeStartPosition(const QString&)));

  SignalMapperOffset = new QSignalMapper(this);
  connect(SignalMapperOffset, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangeOffset(const QString&)));

  SignalMapperLength = new QSignalMapper(this);
  connect(SignalMapperLength, SIGNAL(mapped(const QString&)),
          this, SLOT(slotChangeLength(const QString&)));

  QVBox       *VBoxBase = new QVBox(this);
  QWidget     *WidgetMisc = new QWidget(VBoxBase);
  QHBoxLayout *HBoxLayout = new QHBoxLayout(WidgetMisc);
  QLabel      *LabelPosition = new QLabel("&Master Position (MM:SS)", WidgetMisc);
  HBoxLayout->addWidget(LabelPosition);
  TimeEditPosition = new QTimeEdit(WidgetMisc);
  TimeEditPosition->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
  connect(TimeEditPosition, SIGNAL(valueChanged(const QTime&)),
          this, SIGNAL(masterPositionChanged(const QTime&)));
  HBoxLayout->addWidget(TimeEditPosition);
  LabelPosition->setBuddy(TimeEditPosition);
  TimeEditPosition->setDisplay(
      QTimeEdit::Minutes | QTimeEdit::Seconds);

  LabelProceed = new QLabel("   Position (MM:SS)", WidgetMisc);
  HBoxLayout->addWidget(LabelProceed);
  TimeEditProceed = new QTimeEdit(WidgetMisc);
  TimeEditProceed->setSizePolicy(QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed));
  HBoxLayout->addWidget(TimeEditProceed);
  LabelProceed->setBuddy(TimeEditProceed);
  TimeEditProceed->setDisplay(
      QTimeEdit::Minutes | QTimeEdit::Seconds);

  HBoxLayout->addStretch();

  QSplitter   *Splitter = new QSplitter(Vertical, VBoxBase);
  QScrollView *ScrollView = new QScrollView(Splitter);
  ScrollView->setHScrollBarMode(QScrollView::AlwaysOff);
  ScrollView->setVScrollBarMode(QScrollView::AlwaysOn);

  VBoxTracks = new QVBox(Splitter);
  VBoxTracks->setMinimumHeight(300);
  ScrollView->addChild(VBoxTracks);

  Tab = new QTabWidget(Splitter);
  Tab->setTabPosition(QTabWidget::Bottom);
  //  TextEditCmdLine = new KTextEdit(Tab);
  //  Tab->addTab(TextEditCmdLine, "Commandline");
  TextEditEcasound = new KTextEdit(Tab);
  TextEditEcasound->setReadOnly(true);
  Tab->addTab(TextEditEcasound, "Ecasound console");
}

/////////////////////////////////////////////////////////////////////////////

int 
WVoxBase::getIndexByName(const QString& strTrackName) const
{
  int i, nTrack;

  nTrack = vVoxTracks.size();  
  for ( i = 0; i < nTrack; i++ ) {
    if ( strTrackName == vVoxTracks[i]->name() ) {
      return i;
    }
  }

  return -1;
}

/////////////////////////////////////////////////////////////////////////////

bool
WVoxBase::queryExistingTrackName(const QString& strName) const
{
  int i, nTrack;
  
  nTrack = vVoxTracks.size();
  for ( i = 0; i < nTrack; i++ ) {
    if ( vVoxTracks[i]->name() == strName ) {
      return true;
    }
  }

  return false;
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::setEcasoundCmd(const QString& strCmd)
{
  TextEditCmdLine->clear();
  TextEditCmdLine->setText(strCmd);
}

/////////////////////////////////////////////////////////////////////////////

QString
WVoxBase::ecasoundCmd() const
{
  return TextEditCmdLine->text();
}

/////////////////////////////////////////////////////////////////////////////

QDomNode
WVoxBase::stateInDOM(QDomDocument* pDoc)
{
  QDomElement eleTracks = pDoc->createElement("Tracks");
  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();
  while ( it != vVoxTracks.end() ) {
    eleTracks.appendChild((*it)->stateInDOM(pDoc));
    it++;
  }

  return eleTracks;
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::setMaxSessionLength(const QTime& time)
{
  timeMaxSessionLength = time;
  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();
  while ( it != vVoxTracks.end() ) {
    (*it)->setMaxSessionLength(time);
    it++;
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::resizeEvent(QResizeEvent* Event)
{
  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();
  VBoxTracks->resize(Event->size().width() - 24, VBoxTracks->height());
  while ( it != vVoxTracks.end() ) {
    (*it)->resize(Event->size().width() - 24, (*it)->height());
    it++;
  }

  QVBox::resizeEvent(Event);
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::timerEvent(QTimerEvent* Event)
{
  if ( Event->timerId() == nTimerIDProceed ) {  // playing
    timeProceed = timeProceed.addSecs(1);
    TimeEditProceed->setTime(timeProceed);
  } else if ( Event->timerId() == nTimerIDPausing ) {  // pausing
  }

  QVBox::timerEvent(Event);
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotWriteConsoleMessage(const QString& strMessage)
{
  TextEditEcasound->append(strMessage);
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeMessageTab(TabType type)
{
  if ( type == WVoxBase::CommandLine ) {
    Tab->setCurrentPage(0);
  } else if ( type == WVoxBase::Console ) {
    Tab->setCurrentPage(0);
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeState(State state)
{
  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();

  // PLAY
  if ( state == Play ) {
    while ( it != vVoxTracks.end() ) {
      (*it)->slotSetEnabledWidgets(
               WVoxTrack::Record |
               WVoxTrack::File |
               WVoxTrack::Remove |
               WVoxTrack::Device |
               WVoxTrack::StartPosition |
               WVoxTrack::Offset |
               WVoxTrack::Length,
               false);
      it++;
    }
    if ( nTimerIDProceed == 0 && nTimerIDPausing != 0 ) {  // in pausing
      nTimerIDProceed = nTimerIDPausing;
      nTimerIDPausing = 0;
    } else {
      timeProceed = QTime();
      TimeEditProceed->setTime(timeProceed);
      TimeEditProceed->show();
      LabelProceed->show();
      nTimerIDProceed = startTimer(1000); // 1 second timer
      nTimerIDPausing = 0;
    }
  }
  // PAUSE
  else if ( state == Pause ) {
    while ( it != vVoxTracks.end() ) {
      (*it)->slotSetEnabledWidgets(
               WVoxTrack::Record |
               WVoxTrack::File |
               WVoxTrack::Remove |
               WVoxTrack::Device,
              true);
      (*it)->slotSetEnabledWidgets(
               WVoxTrack::Record |
               WVoxTrack::StartPosition |
               WVoxTrack::Offset |
               WVoxTrack::Length,
               false);
      it++;
    }
    nTimerIDPausing = nTimerIDProceed;
    nTimerIDProceed = 0;
  }
  // STOP
  else if ( state == Stop ) {
    TimeEditProceed->hide();
    LabelProceed->hide();
    killTimer(nTimerIDProceed);
    nTimerIDProceed = 0;
    nTimerIDPausing = 0;
    timeProceed = TimeEditPosition->time();
    while ( it != vVoxTracks.end() ) {
      (*it)->slotSetEnabledWidgets(
               WVoxTrack::Record |
               WVoxTrack::File |
               WVoxTrack::Remove |
               WVoxTrack::Device |
               WVoxTrack::StartPosition |
               WVoxTrack::Offset |
               WVoxTrack::Length,
               true);
      it++;
    }
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotNotifySucceedInRecording()
{
  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();

  while ( it != vVoxTracks.end() ) {
    if ( (*it)->isSetRec() ) {
      (*it)->slotSetStartPosition(QTime(0,0));
      (*it)->slotSetOffset(QTime(0,0));
      (*it)->slotSetLength(QTime(0,0));
    }
    it++;
  }  
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotAddTrack()
{
  addTrack("/dev/dsp", "/dev/dsp");
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangePosition(const QTime& time)
{
  TimeEditPosition->setTime(time);
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::slotChangePlaybackDevice(const QString& strTrackName)
{
  emit playbackDeviceChanged(strTrackName,
                       vVoxTracks[getIndexByName(strTrackName)]->playbackDevice());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeRecordingDevice(const QString& strTrackName)
{
  emit recordingDeviceChanged(strTrackName,
                       vVoxTracks[getIndexByName(strTrackName)]->recordingDevice());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotRemove(const QString& strTrackName)
{
  removeTrack(strTrackName);
  emit trackRemoved(strTrackName);
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeFileName(const QString& strTrackName)
{
  emit fileNameChanged(strTrackName,
                       vVoxTracks[getIndexByName(strTrackName)]->fileName());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeLevel(const QString& strTrackName)
{
  emit levelChanged(strTrackName,
		    vVoxTracks[getIndexByName(strTrackName)]->level());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangePan(const QString& strTrackName)
{
  emit panChanged(strTrackName,
		  vVoxTracks[getIndexByName(strTrackName)]->pan());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotToggleMute(const QString& strTrackName)
{
  emit muteToggled(strTrackName,
		   vVoxTracks[getIndexByName(strTrackName)]->isMuted());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotToggleRec(const QString& strTrackName)
{
  emit recToggled(strTrackName,
		  vVoxTracks[getIndexByName(strTrackName)]->isSetRec());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeStartPosition(const QString& strTrackName)
{
  emit startPositionChanged(strTrackName,
		  vVoxTracks[getIndexByName(strTrackName)]->startPosition());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeOffset(const QString& strTrackName)
{
  emit offsetChanged(strTrackName,
		  vVoxTracks[getIndexByName(strTrackName)]->offset());
}

/////////////////////////////////////////////////////////////////////////////

void
WVoxBase::slotChangeLength(const QString& strTrackName)
{
  emit lengthChanged(strTrackName,
		  vVoxTracks[getIndexByName(strTrackName)]->length());
}

/////////////////////////////////////////////////////////////////////////////

void 
WVoxBase::slotSetScrollToAll(QObject* ObjectSender, int x)
{
  QValueVector<WVoxTrack*>::iterator it = vVoxTracks.begin();

  it = vVoxTracks.begin();
  while ( it != vVoxTracks.end() ) {
    if ( (*it) != ObjectSender ) {
      disconnect(*it, SIGNAL(locatorScrolled(QObject*, int)), 
                 this, SLOT(slotSetScrollToAll(QObject*, int)));
      (*it)->scrollLocator(x);
      connect(*it, SIGNAL(locatorScrolled(QObject*, int)), 
              this, SLOT(slotSetScrollToAll(QObject*, int)));
    }
    it++;
  }
}

/////////////////////////////////////////////////////////////////////////////

#include "wvoxbase.moc"
