/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "jump.h"
#include <gdk/gdkkeysyms.h>
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ジャンプダイアログ関数群                                                    *
*                                                                             *
******************************************************************************/
static gboolean jump_clicked_ok;
static GtkWidget *dialog,*button0,*entry,*label;


/* OKボタンが押された */
static void jump_dialog_clicked(GtkWidget *widget,JumpDialog *jmp)
{
    misc_str_to_val(&jmp->frame,gtk_entry_get_text(GTK_ENTRY(entry)),10,FALSE);
    gtk_widget_destroy(dialog);
    jump_clicked_ok=TRUE;
}


/* エントリーでリターンが押された */
static void jump_dialog_activate(GtkWidget *widget,JumpDialog *jmp)
{
    gint value;

    if (misc_str_to_val(&value,gtk_entry_get_text(GTK_ENTRY(widget)),10,FALSE)
                                                && 0<=value && value<=jmp->max)
        jump_dialog_clicked(widget,jmp);
}


/* エントリーが変更された */
static void jump_dialog_changed(GtkWidget *widget,JumpDialog *jmp)
{
    gchar *text;
    gint t,value;

    if (misc_str_to_val(&value,
                            gtk_entry_get_text(GTK_ENTRY(widget)),10,FALSE)) {
#ifdef G_HAVE_GINT64
        t=(gint64)value*jmp->scale*1000/jmp->rate;
#else /* not G_HAVE_GINT64 */
        t = value * jmp->scale * 1000 / jmp->rate;
#endif /* not G_HAVE_GINT64 */
        text=g_strdup_printf("%02d:%02d:%02d",t/60000%100,t/1000%60,t/10%100);
        gtk_label_set_text(GTK_LABEL(label),text);
        g_free(text);
        gtk_widget_set_sensitive(button0,0<=value && value<=jmp->max);
    } else {
        gtk_widget_set_sensitive(button0,FALSE);
    }
}


/* ESCが押された */
static gboolean jump_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
                                                            gpointer user_data)
{
    if (event->keyval==GDK_Escape)
        gtk_widget_destroy(widget);
    return FALSE;
}


gboolean jump_dialog(JumpDialog *jmp)
{
    gchar *text;
    GtkWidget *button1,*hbox,*vbox;

    /* メインウインドウ */
    dialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title(GTK_WINDOW(dialog),_("Jump"));
    g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (jump_dialog_key_press), NULL);
    g_signal_connect (G_OBJECT (dialog), "destroy", gtk_main_quit, NULL);
    /* ボタン */
    button0=gtk_button_new_with_label(_("OK"));
    button1=gtk_button_new_with_label(_("Cancel"));
    g_signal_connect (G_OBJECT (button0), "clicked",
                                        G_CALLBACK (jump_dialog_clicked), jmp);
    g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
    GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
    GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
    /* ラベル */
    label=gtk_label_new(NULL);
    /* エントリー */
    entry=gtk_entry_new();
    g_signal_connect (G_OBJECT (entry), "changed",
                                        G_CALLBACK (jump_dialog_changed), jmp);
    text=misc_str_from_val(jmp->frame,10,0,FALSE);
    gtk_entry_set_text(GTK_ENTRY(entry),text);
    g_free(text);
    g_signal_connect (G_OBJECT (entry), "activate",
                                    G_CALLBACK (jump_dialog_activate), jmp);
    gtk_editable_select_region(GTK_EDITABLE(entry),0,-1);
    /* フレームとボックス */
    vbox = gtk_vbox_new (FALSE, SPACING);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
    gtk_box_pack_start(GTK_BOX(vbox),entry,TRUE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
    hbox = gtk_hbox_new (FALSE, SPACING);
    gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
    gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
    gtk_container_add(GTK_CONTAINER(dialog),vbox);

    /* 表示 */
    gtk_widget_set_sensitive(button0,FALSE);
    gtk_widget_grab_focus(entry);
    jump_clicked_ok=FALSE;

    gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
    gtk_grab_add(dialog);
    gtk_widget_show_all(dialog);
    gtk_main();

    return jump_clicked_ok;
}
