/*
    dllloader
    (C)Copyright 2000, 2001 by Hiroshi Takekawa
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __WINDEF_H__
#define __WINDEF_H__


#include <glib.h>


#ifdef __cplusplus
extern "C" {
#endif


#define __stdcall __attribute__((__stdcall__))
#define CALLBACK __stdcall
#define PASCAL __stdcall
#define WINAPI __stdcall


/* Macros to split words and longs. */
#define LOBYTE(w)				((BYTE)(WORD)(w))
#define HIBYTE(w)				((BYTE)((WORD)(w) >> 8))
#define LOWORD(l)				((WORD)(DWORD)(l))
#define HIWORD(l)				((WORD)((DWORD)(l) >> 16))
#define SLOWORD(l)				((SHORT)(LONG)(l))
#define SHIWORD(l)				((SHORT)((LONG)(l) >> 16))
#define MAKEWORD(low,high)		((WORD)(((BYTE)(low)) \
												| ((WORD)((BYTE)(high))) << 8))
#define MAKELONG(low,high)		((LONG)(((WORD)(low)) \
											| (((DWORD)((WORD)(high))) << 16)))
#define MAKELPARAM(low,high)	((LPARAM)MAKELONG(low,high))
#define MAKEWPARAM(low,high)	((WPARAM)MAKELONG(low,high))
#define MAKELRESULT(low,high)	((LRESULT)MAKELONG(low,high))


/* { */
#define CONST const
typedef gint32		BOOL,	*PBOOL,		*LPBOOL;
typedef void		VOID,	*PVOID,		*LPVOID;
typedef const void	CVOID,	*PCVOID,	*LPCVOID;
typedef gint8		CHAR,	*PCHAR,		*LPCHAR,	*CHAR_PTR;
typedef guint8		UCHAR,	*PUCHAR,	*LPUCHAR,	*UCHAR_PTR;
typedef gint16		SHORT,	*PSHORT,	*LPSHORT,	*SHORT_PTR;
typedef guint16		USHORT,	*PUSHORT,	*LPUSHORT,	*USHORT_PTR;
typedef gint32		INT,	*PINT,		*LPINT,		*INT_PTR;
typedef guint32		UINT,	*PUINT,		*LPUINT,	*UINT_PTR;
typedef gint32		LONG,	*PLONG,		*LPLONG,	*LONG_PTR;
typedef guint32		ULONG,	*PULONG,	*LPULONG,	*ULONG_PTR;
typedef guint32		SIZE_T;
/* WORD */
typedef UCHAR		BYTE,	*PBYTE,		*LPBYTE;
typedef USHORT		WORD,	*PWORD,		*LPWORD;
typedef ULONG		DWORD,	*PDWORD,	*LPDWORD;
/*  */
typedef USHORT		WCHAR;
typedef CHAR 				*PSTR,		*LPSTR;
typedef CONST CHAR 			*PCSTR,		*LPCSTR;
typedef WCHAR 				*PWSTR,		*LPWSTR;
typedef CONST WCHAR			*PCWSTR,	*LPCWSTR;
/* R[obN */
typedef LONG LRESULT;
typedef LONG LPARAM;
typedef LONG WPARAM;
/* nh */
typedef LPVOID HANDLE;
typedef HANDLE HDC;
typedef HANDLE HGDI;
typedef HANDLE HGLOBAL;
typedef HANDLE HINSTANCE;
typedef HANDLE HMODULE;
typedef HANDLE HWND;
/* ֐ */
typedef LRESULT CALLBACK (*FARPROC)(VOID);
typedef LRESULT CALLBACK (*WNDPROC)(HWND,UINT,WPARAM,LPARAM);
typedef BOOL CALLBACK (*DLGPROC)(HWND,UINT,WPARAM,LPARAM);
/* \ */
#include "pshpack1.h"
typedef struct {
	DWORD dwLowDateTime;
	DWORD dwHighDateTime;
} FILETIME,*PFILETIME,*LPFILETIME;
typedef struct _SECURITY_ATTRIBUTES {
	DWORD nLength;
	LPVOID lpSecurityDescriptor;
	BOOL bInheritHandle;
} SECURITY_ATTRIBUTES,*PSECURITY_ATTRIBUTES,*LPSECURITY_ATTRIBUTES;
typedef struct tagPOINT {
	LONG x;
	LONG y;
} POINT,*PPOINT,*LPPOINT;
typedef struct tagRECT {
	INT left;
	INT top;
	INT right;
	INT bottom;
} RECT,*PRECT,*LPRECT;
typedef const RECT *LPCRECT;
typedef struct{
	HDC hdc;
	BOOL fErase;
	RECT rcPaint;
	BOOL fRestore;
	BOOL fIncUpdate;
	BYTE rgbReserved[32];
} PAINTSTRUCT,*PPAINTSTRUCT,*LPPAINTSTRUCT;
#include "poppack.h"


#ifdef __cplusplus
}
#endif
#endif
