/*
    avicore
    copyright (c) 2000-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Avi Core                                                                    *
*                                                                             *
******************************************************************************/
#include "avicore.h"
#include "avifmt.h"
#include "misc/fileio.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* Avi                                                                     *
*                                                                             *
******************************************************************************/
const guint8 rgb2[8]={0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00};
const guint8 rgb16[64]={
			0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,
			0x00,0xFF,0xFF,0x00,0xFF,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,
			0xFF,0xFF,0x00,0x00,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,
			0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0xFF,0xFF,0x00,
			0xFF,0x00,0x00,0x00,0xFF,0x00,0xFF,0x00,0xFF,0xFF,0x00,0x00,
			0xFF,0xFF,0xFF,0x00};
const guint8 rgb256[1024]={
			0x00,0x00,0x00,0x00,0x55,0x00,0x00,0x00,0xAA,0x00,0x00,0x00,
			0xFF,0x00,0x00,0x00,0x00,0x24,0x00,0x00,0x55,0x24,0x00,0x00,
			0xAA,0x24,0x00,0x00,0xFF,0x24,0x00,0x00,0x00,0x49,0x00,0x00,
			0x55,0x49,0x00,0x00,0xAA,0x49,0x00,0x00,0xFF,0x49,0x00,0x00,
			0x00,0x6D,0x00,0x00,0x55,0x6D,0x00,0x00,0xAA,0x6D,0x00,0x00,
			0xFF,0x6D,0x00,0x00,0x00,0x92,0x00,0x00,0x55,0x92,0x00,0x00,
			0xAA,0x92,0x00,0x00,0xFF,0x92,0x00,0x00,0x00,0xB6,0x00,0x00,
			0x55,0xB6,0x00,0x00,0xAA,0xB6,0x00,0x00,0xFF,0xB6,0x00,0x00,
			0x00,0xDB,0x00,0x00,0x55,0xDB,0x00,0x00,0xAA,0xDB,0x00,0x00,
			0xFF,0xDB,0x00,0x00,0x00,0xFF,0x00,0x00,0x55,0xFF,0x00,0x00,
			0xAA,0xFF,0x00,0x00,0xFF,0xFF,0x00,0x00,0x00,0x00,0x24,0x00,
			0x55,0x00,0x24,0x00,0xAA,0x00,0x24,0x00,0xFF,0x00,0x24,0x00,
			0x00,0x24,0x24,0x00,0x55,0x24,0x24,0x00,0xAA,0x24,0x24,0x00,
			0xFF,0x24,0x24,0x00,0x00,0x49,0x24,0x00,0x55,0x49,0x24,0x00,
			0xAA,0x49,0x24,0x00,0xFF,0x49,0x24,0x00,0x00,0x6D,0x24,0x00,
			0x55,0x6D,0x24,0x00,0xAA,0x6D,0x24,0x00,0xFF,0x6D,0x24,0x00,
			0x00,0x92,0x24,0x00,0x55,0x92,0x24,0x00,0xAA,0x92,0x24,0x00,
			0xFF,0x92,0x24,0x00,0x00,0xB6,0x24,0x00,0x55,0xB6,0x24,0x00,
			0xAA,0xB6,0x24,0x00,0xFF,0xB6,0x24,0x00,0x00,0xDB,0x24,0x00,
			0x55,0xDB,0x24,0x00,0xAA,0xDB,0x24,0x00,0xFF,0xDB,0x24,0x00,
			0x00,0xFF,0x24,0x00,0x55,0xFF,0x24,0x00,0xAA,0xFF,0x24,0x00,
			0xFF,0xFF,0x24,0x00,0x00,0x00,0x49,0x00,0x55,0x00,0x49,0x00,
			0xAA,0x00,0x49,0x00,0xFF,0x00,0x49,0x00,0x00,0x24,0x49,0x00,
			0x55,0x24,0x49,0x00,0xAA,0x24,0x49,0x00,0xFF,0x24,0x49,0x00,
			0x00,0x49,0x49,0x00,0x55,0x49,0x49,0x00,0xAA,0x49,0x49,0x00,
			0xFF,0x49,0x49,0x00,0x00,0x6D,0x49,0x00,0x55,0x6D,0x49,0x00,
			0xAA,0x6D,0x49,0x00,0xFF,0x6D,0x49,0x00,0x00,0x92,0x49,0x00,
			0x55,0x92,0x49,0x00,0xAA,0x92,0x49,0x00,0xFF,0x92,0x49,0x00,
			0x00,0xB6,0x49,0x00,0x55,0xB6,0x49,0x00,0xAA,0xB6,0x49,0x00,
			0xFF,0xB6,0x49,0x00,0x00,0xDB,0x49,0x00,0x55,0xDB,0x49,0x00,
			0xAA,0xDB,0x49,0x00,0xFF,0xDB,0x49,0x00,0x00,0xFF,0x49,0x00,
			0x55,0xFF,0x49,0x00,0xAA,0xFF,0x49,0x00,0xFF,0xFF,0x49,0x00,
			0x00,0x00,0x6D,0x00,0x55,0x00,0x6D,0x00,0xAA,0x00,0x6D,0x00,
			0xFF,0x00,0x6D,0x00,0x00,0x24,0x6D,0x00,0x55,0x24,0x6D,0x00,
			0xAA,0x24,0x6D,0x00,0xFF,0x24,0x6D,0x00,0x00,0x49,0x6D,0x00,
			0x55,0x49,0x6D,0x00,0xAA,0x49,0x6D,0x00,0xFF,0x49,0x6D,0x00,
			0x00,0x6D,0x6D,0x00,0x55,0x6D,0x6D,0x00,0xAA,0x6D,0x6D,0x00,
			0xFF,0x6D,0x6D,0x00,0x00,0x92,0x6D,0x00,0x55,0x92,0x6D,0x00,
			0xAA,0x92,0x6D,0x00,0xFF,0x92,0x6D,0x00,0x00,0xB6,0x6D,0x00,
			0x55,0xB6,0x6D,0x00,0xAA,0xB6,0x6D,0x00,0xFF,0xB6,0x6D,0x00,
			0x00,0xDB,0x6D,0x00,0x55,0xDB,0x6D,0x00,0xAA,0xDB,0x6D,0x00,
			0xFF,0xDB,0x6D,0x00,0x00,0xFF,0x6D,0x00,0x55,0xFF,0x6D,0x00,
			0xAA,0xFF,0x6D,0x00,0xFF,0xFF,0x6D,0x00,0x00,0x00,0x92,0x00,
			0x55,0x00,0x92,0x00,0xAA,0x00,0x92,0x00,0xFF,0x00,0x92,0x00,
			0x00,0x24,0x92,0x00,0x55,0x24,0x92,0x00,0xAA,0x24,0x92,0x00,
			0xFF,0x24,0x92,0x00,0x00,0x49,0x92,0x00,0x55,0x49,0x92,0x00,
			0xAA,0x49,0x92,0x00,0xFF,0x49,0x92,0x00,0x00,0x6D,0x92,0x00,
			0x55,0x6D,0x92,0x00,0xAA,0x6D,0x92,0x00,0xFF,0x6D,0x92,0x00,
			0x00,0x92,0x92,0x00,0x55,0x92,0x92,0x00,0xAA,0x92,0x92,0x00,
			0xFF,0x92,0x92,0x00,0x00,0xB6,0x92,0x00,0x55,0xB6,0x92,0x00,
			0xAA,0xB6,0x92,0x00,0xFF,0xB6,0x92,0x00,0x00,0xDB,0x92,0x00,
			0x55,0xDB,0x92,0x00,0xAA,0xDB,0x92,0x00,0xFF,0xDB,0x92,0x00,
			0x00,0xFF,0x92,0x00,0x55,0xFF,0x92,0x00,0xAA,0xFF,0x92,0x00,
			0xFF,0xFF,0x92,0x00,0x00,0x00,0xB6,0x00,0x55,0x00,0xB6,0x00,
			0xAA,0x00,0xB6,0x00,0xFF,0x00,0xB6,0x00,0x00,0x24,0xB6,0x00,
			0x55,0x24,0xB6,0x00,0xAA,0x24,0xB6,0x00,0xFF,0x24,0xB6,0x00,
			0x00,0x49,0xB6,0x00,0x55,0x49,0xB6,0x00,0xAA,0x49,0xB6,0x00,
			0xFF,0x49,0xB6,0x00,0x00,0x6D,0xB6,0x00,0x55,0x6D,0xB6,0x00,
			0xAA,0x6D,0xB6,0x00,0xFF,0x6D,0xB6,0x00,0x00,0x92,0xB6,0x00,
			0x55,0x92,0xB6,0x00,0xAA,0x92,0xB6,0x00,0xFF,0x92,0xB6,0x00,
			0x00,0xB6,0xB6,0x00,0x55,0xB6,0xB6,0x00,0xAA,0xB6,0xB6,0x00,
			0xFF,0xB6,0xB6,0x00,0x00,0xDB,0xB6,0x00,0x55,0xDB,0xB6,0x00,
			0xAA,0xDB,0xB6,0x00,0xFF,0xDB,0xB6,0x00,0x00,0xFF,0xB6,0x00,
			0x55,0xFF,0xB6,0x00,0xAA,0xFF,0xB6,0x00,0xFF,0xFF,0xB6,0x00,
			0x00,0x00,0xDB,0x00,0x55,0x00,0xDB,0x00,0xAA,0x00,0xDB,0x00,
			0xFF,0x00,0xDB,0x00,0x00,0x24,0xDB,0x00,0x55,0x24,0xDB,0x00,
			0xAA,0x24,0xDB,0x00,0xFF,0x24,0xDB,0x00,0x00,0x49,0xDB,0x00,
			0x55,0x49,0xDB,0x00,0xAA,0x49,0xDB,0x00,0xFF,0x49,0xDB,0x00,
			0x00,0x6D,0xDB,0x00,0x55,0x6D,0xDB,0x00,0xAA,0x6D,0xDB,0x00,
			0xFF,0x6D,0xDB,0x00,0x00,0x92,0xDB,0x00,0x55,0x92,0xDB,0x00,
			0xAA,0x92,0xDB,0x00,0xFF,0x92,0xDB,0x00,0x00,0xB6,0xDB,0x00,
			0x55,0xB6,0xDB,0x00,0xAA,0xB6,0xDB,0x00,0xFF,0xB6,0xDB,0x00,
			0x00,0xDB,0xDB,0x00,0x55,0xDB,0xDB,0x00,0xAA,0xDB,0xDB,0x00,
			0xFF,0xDB,0xDB,0x00,0x00,0xFF,0xDB,0x00,0x55,0xFF,0xDB,0x00,
			0xAA,0xFF,0xDB,0x00,0xFF,0xFF,0xDB,0x00,0x00,0x00,0xFF,0x00,
			0x55,0x00,0xFF,0x00,0xAA,0x00,0xFF,0x00,0xFF,0x00,0xFF,0x00,
			0x00,0x24,0xFF,0x00,0x55,0x24,0xFF,0x00,0xAA,0x24,0xFF,0x00,
			0xFF,0x24,0xFF,0x00,0x00,0x49,0xFF,0x00,0x55,0x49,0xFF,0x00,
			0xAA,0x49,0xFF,0x00,0xFF,0x49,0xFF,0x00,0x00,0x6D,0xFF,0x00,
			0x55,0x6D,0xFF,0x00,0xAA,0x6D,0xFF,0x00,0xFF,0x6D,0xFF,0x00,
			0x00,0x92,0xFF,0x00,0x55,0x92,0xFF,0x00,0xAA,0x92,0xFF,0x00,
			0xFF,0x92,0xFF,0x00,0x00,0xB6,0xFF,0x00,0x55,0xB6,0xFF,0x00,
			0xAA,0xB6,0xFF,0x00,0xFF,0xB6,0xFF,0x00,0x00,0xDB,0xFF,0x00,
			0x55,0xDB,0xFF,0x00,0xAA,0xDB,0xFF,0x00,0xFF,0xDB,0xFF,0x00,
			0x00,0xFF,0xFF,0x00,0x55,0xFF,0xFF,0x00,0xAA,0xFF,0xFF,0x00,
			0xFF,0xFF,0xFF,0x00};


/*	AVIե
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
void avi_get_file(AviEdit *avi_edit,const gint pos)
{
	while (pos<avi_edit->offset && avi_edit->file->prev!=NULL) {
		avi_edit->file=avi_edit->file->prev;
		avi_edit->offset-=avi_edit->file->length;
	}
	while (avi_edit->offset+avi_edit->file->length<=pos
											&& avi_edit->file->next!=NULL) {
		avi_edit->offset+=avi_edit->file->length;
		avi_edit->file=avi_edit->file->next;
	}
}


/*	AVIեʬΥ
	avi_edit,AVIԽϥɥ
	     pos,ץֹ													*/
void avi_split_file(AviEdit *avi_edit,const gint pos)
{
	AviFile *avi_file;

	if (pos<0 || avi_length(avi_edit)<=pos)
		return;

	/* ֤ */
	avi_get_file(avi_edit,pos);/* AVIե */
	if (avi_edit->offset==pos)
		return;/* եڤܤ˰פ */

	/* ΥեʬΥ */
	avi_file=g_malloc(sizeof(AviFile));
	avi_file->fio = avi_edit->file->fio != NULL
					? fileio_open (avi_edit->file->name, FILEIO_ACCESS_READ,
						FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING) : NULL;
	avi_file->data=avi_edit->file->data!=NULL && avi_edit->file->bmih!=NULL
		?g_memdup(avi_edit->file->data,bm_image_bytes(avi_edit->file->bmih))
																		:NULL;
	avi_file->name=g_strdup(avi_edit->file->name);
	avi_file->start=pos-avi_edit->offset+avi_edit->file->start;
	avi_file->length=avi_edit->file->length-(pos-avi_edit->offset);
	avi_file->entries=avi_edit->file->entries;
	avi_file->param=avi_edit->file->param;
	avi_file->index=g_memdup(avi_edit->file->index,
									avi_edit->file->entries*sizeof(AviIndex));
	avi_file->handler=avi_edit->file->handler;
	avi_file->bmih=avi_edit->file->bmih!=NULL?g_memdup(avi_edit->file->bmih,
								bm_header_bytes(avi_edit->file->bmih)):NULL;
	avi_file->wfx=avi_edit->file->wfx!=NULL?g_memdup(avi_edit->file->wfx,
									wf_header_bytes(avi_edit->file->wfx)):NULL;
	/* Υեѹ */
	avi_edit->file->length-=avi_file->length;
	/* ꥹȤ */
	avi_file->prev=avi_edit->file;
	avi_file->next=avi_edit->file->next;
	avi_file->prev->next=avi_file;
	if (avi_file->next!=NULL)
		avi_file->next->prev=avi_file;
	avi_get_file(avi_edit,pos);
}


/******************************************************************************
*                                                                             *
* AVIե빽¤δؿ                                                       *
*                                                                             *
******************************************************************************/
/*	AVIAVIե빽¤Τ
	    file,ե̾
	   param,ȥ꡼ֹ
	    type,AVI_STREAM_AUDIO/AVI_STREAM_VIDEO
	    rate,졼
	   scale,
	priority,ͥ
	language,
	    name,̾
	     RET,AVIե빽¤,NULL:顼									*/
static AviFile *
avi_open_avi (const gchar *file, const gint param,
							guint32 *type, guint32 *rate, guint32 *scale,
							guint16 *priority, guint16 *language, gchar **name)
{
	gchar *strn;
	gint i, j;
	guint32 id, size;
	goffset offset;				/* AVIΥࡼӡ */
	AviFile *avi_file;
	AviBaseIndex abi;
	AviBaseIndexEntry abe;
	AviSuperIndex asi;
	AviSuperIndexEntry ase;
	AviIndexEntry aie;
	AviStreamHeader *ash;
	Chunk *ck;

	avi_file = g_malloc0 (sizeof (AviFile));
	/* ե򳫤 */
	avi_file->fio = fileio_open (file, FILEIO_ACCESS_READ,
								FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
	if (avi_file->fio == NULL)
	  {
		g_free (avi_file);
		return NULL;
	  }
	/* եǥ꥿󥯥ݥ󥿤 */
	ck = chunk_open (avi_file->fio);
	/* RIFF󥯤 */
	if (!chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	/* եबhdrlLIST󥯤õ */
	while (chunk_form (avi_file->fio) != CK_LIST_AVIHEADER)
		if (!chunk_next (avi_file->fio, ck))
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (avi_file);
			return NULL;
		  }
	/* եबhdrlLIST󥯤(RIFF'AVI ' -> LIST'hdrl') */
	if (!chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	/* եबstrlLIST󥯤õ */
	for (i = 0;i <= param; i++)
		do
			if (!chunk_next (avi_file->fio, ck))
			  {
				chunk_free (ck);
				fileio_close (avi_file->fio);
				g_free (avi_file);
				return NULL;
			  }
		while (chunk_form (avi_file->fio) != CK_LIST_STREAMHEADER);
	/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
	if (!chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	/* strh󥯤õ(AviStreamHeader) */
	while (chunk_id (avi_file->fio) != CK_ID_STREAMHEADER)
		if (!chunk_next (avi_file->fio, ck))
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (avi_file);
			return NULL;
		  }
	/* strh󥯤Υ(AviStreamHeader) */
	if ((size = chunk_size (avi_file->fio)) == -1 || size < ASH_SIZE)
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	ash = g_malloc (ASH_SIZE);
	/* strh󥯤(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strh) */
	if (!chunk_in (avi_file->fio, ck)
		/* AviStreamHeaderɤ߹ */
				|| fileio_read (avi_file->fio, ash, ASH_SIZE) != ASH_SIZE
		/*  */
				|| (ash_get_type (ash) != AVI_STREAM_AUDIO
									&& ash_get_type (ash) != AVI_STREAM_VIDEO)
		/* strh󥯤Ф(AVIStreamHeader)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' <- strh) */
				|| !chunk_out (avi_file->fio, ck)
		/* եबstrlLIST󥯤Ф
									(RIFF'AVI ' -> LIST'hdrl' <- LIST'strl') */
				|| !chunk_out (avi_file->fio, ck)
		/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
				|| !chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (ash);
		g_free (avi_file);
		return NULL;
	  }
	/* strf󥯤õ(BitmapInfoHeader)|(WaveFormatEx) */
	while (chunk_id (avi_file->fio) != CK_ID_STREAMFORMAT)
		if (!chunk_next (avi_file->fio, ck))
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file);
			return NULL;
		  }
	/* strf󥯤Υ(BitmapInfoHeader)|(WaveFormatEx) */
	size = chunk_size (avi_file->fio);
	if (size == -1)
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (ash);
		g_free (avi_file);
		return NULL;
	  }
	if (ash_get_type (ash) == AVI_STREAM_VIDEO)
	  {
		if (size < BMIH_SIZE)
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file);
			return NULL;
		}
		avi_file->bmih = g_malloc (size);
	  }
	else
	  {
		if (size < WFX_SIZE - sizeof (guint16))
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file);
			return NULL;
		  }
		avi_file->wfx = g_malloc (MAX (size, WFX_SIZE));
		wfx_set_size (avi_file->wfx, 0);
	  }
	/* strf󥯤(BitmapInfoHeader)|(WaveFormatEx)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strf) */
	if (!chunk_in (avi_file->fio, ck)
		/* BitmapInfoHeader|WaveFormatExɤ߹ */
		|| fileio_read (avi_file->fio, ash_get_type (ash) == AVI_STREAM_VIDEO
			? (gpointer)avi_file->bmih : (gpointer)avi_file->wfx, size) != size
		/* strf󥯤Ф(BitmapInfoHeader)|(WaveFormatEx)
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' <- strh) */
		|| !chunk_out (avi_file->fio, ck)
		/* եबstrlLIST󥯤Ф
									(RIFF'AVI ' -> LIST'hdrl' <- LIST'strl') */
		|| !chunk_out (avi_file->fio, ck)
		/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
		|| !chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (ash);
		g_free (avi_file->bmih);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	 }
	strn = NULL;
	if (name != NULL)
	  {
		/* strn󥯤õ */
		while ((id = chunk_id (avi_file->fio)) != CK_ID_STREAMNAME)
			if (!chunk_next (avi_file->fio, ck))
				break;
		if (id == CK_ID_STREAMNAME)
		  {
			/* strn󥯤Υ */
			size = chunk_size (avi_file->fio);
			if (size == -1)
			  {
				chunk_free (ck);
				fileio_close (avi_file->fio);
				g_free (ash);
				g_free (avi_file->bmih);
				g_free (avi_file->wfx);
				g_free (avi_file);
				return NULL;
			  }
			strn = g_malloc0 (size + 1);
			/* strn󥯤
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> strn) */
			if (!chunk_in (avi_file->fio, ck)
				/* strnɤ߹ */
					|| fileio_read (avi_file->fio, strn, size) != size
				/* strn󥯤Ф
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' <- strh) */
					|| !chunk_out (avi_file->fio, ck))
			  {
				g_free (strn);
				chunk_free (ck);
				fileio_close (avi_file->fio);
				g_free (ash);
				g_free (avi_file->bmih);
				g_free (avi_file->wfx);
				g_free (avi_file);
				return NULL;
			  }
		  }
		/* եबstrlLIST󥯤Ф
									(RIFF'AVI ' -> LIST'hdrl' <- LIST'strl') */
		if (!chunk_out (avi_file->fio, ck)
			/* եबstrlLIST󥯤
									(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl') */
				|| !chunk_in (avi_file->fio, ck))
		  {
			g_free (strn);
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
	  }

	/* ѡǥå󥯤ذư */

	/* ѡǥå󥯤õ */
	while ((id = chunk_id (avi_file->fio)) != CK_ID_AVISUPERINDEX)
		if (!chunk_next (avi_file->fio, ck))
			break;
	if (id == CK_ID_AVISUPERINDEX)
	  {
		/* ѡǥå󥯤Υ */
		size = chunk_size (avi_file->fio);
		if (size == -1	/* ѡǥå󥯤
							(RIFF'AVI ' -> LIST'hdrl' -> LIST'strl' -> indx) */
					|| !chunk_in (avi_file->fio, ck)
					/* indxɤ߹ */
					|| fileio_read (avi_file->fio, &asi, ASI_SIZE) != ASI_SIZE
					|| size < ASI_SIZE + asi_get_entries (&asi) * ASE_SIZE)
		  {
			g_free (strn);
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
		if (asi_get_longs (&asi) == 4
							&& asi_get_sub_type (&asi) == AVI_IDX_SUB_DEFAULT
								&& asi_get_type (&asi) == AVI_IDX_OF_INDEXES)
			for (i = 0; i < asi_get_entries (&asi); i++)
			  {
				/* ѡǥåȥ꡼ɤ߹ */
				if (fileio_read (avi_file->fio, &ase, ASE_SIZE) != ASE_SIZE)
				  {
					g_free (strn);
					chunk_free (ck);
					fileio_close (avi_file->fio);
					g_free (ash);
					g_free (avi_file->index);
					g_free (avi_file);
					return NULL;
				  }
				if (ase_get_offset (&ase) != 0)
				  {
					/* եΥեåȤ */
					offset = fileio_seek (avi_file->fio, 0, FILEIO_SEEK_CUR);
					/* եΥեåȤꤹ */
					if (offset == -1 || fileio_seek (avi_file->fio,
								ase_get_offset (&ase) + sizeof (guint32) * 2,
														FILEIO_SEEK_SET) == -1
							/* ix##ɤ߹ */
								|| fileio_read (avi_file->fio, &abi, ABI_SIZE)
																!= ABI_SIZE)
					  {
						g_free (strn);
						chunk_free (ck);
						fileio_close (avi_file->fio);
						g_free (ash);
						g_free (avi_file->index);
						g_free (avi_file->bmih);
						g_free (avi_file->wfx);
						g_free (avi_file);
						return NULL;
					  }
					if (abi_get_longs (&abi) == 2
						&& asi_get_sub_type (&asi) == abi_get_sub_type (&abi)
								&& abi_get_type (&abi) == AVI_IDX_OF_CHUNKS)
					  {
						avi_file->index = g_realloc (avi_file->index,
								(avi_file->entries + abi_get_entries (&abi))
														* sizeof(AviIndex));
						for (j = 0; j < abi_get_entries (&abi); j++)
						  {
							/* ѡǥåȥ꡼ɤ߹ */
							if (fileio_read (avi_file->fio, &abe, ABE_SIZE)
																!= ABE_SIZE)
							  {
								g_free (strn);
								chunk_free (ck);
								fileio_close (avi_file->fio);
								g_free (ash);
								g_free (avi_file->index);
								g_free (avi_file->bmih);
								g_free (avi_file->wfx);
								g_free (avi_file);
								return NULL;
							  }
							avi_file->index[avi_file->entries].offset
									= abi_get_offset (&abi)
													+ abe_get_offset (&abe);
							avi_file->index[avi_file->entries].size
									= (abe_get_size (&abe) & 0x7fffffff);
							avi_file->index[avi_file->entries].flags
									= (abe_get_size (&abe) & 0x80000000) == 0
														? AVI_IF_KEYFRAME : 0;
							avi_file->entries++;
						  }
					  }
					/* եΥեåȤꤹ */
					if (fileio_seek (avi_file->fio, offset, FILEIO_SEEK_SET)
																		== -1)
					  {
						g_free (strn);
						chunk_free (ck);
						fileio_close (avi_file->fio);
						g_free (ash);
						g_free (avi_file->index);
						g_free (avi_file->bmih);
						g_free (avi_file->wfx);
						g_free (avi_file);
						return NULL;
					  }
				  }
			  }
	  }

	/* 󥯥ݥ󥿤 */
	if (!chunk_free (ck))
	  {
		g_free (strn);
		fileio_close (avi_file->fio);
		g_free (ash);
		g_free (avi_file->index);
		g_free (avi_file->bmih);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }

	if (avi_file->entries <= 0)
	  {
		/* ࡼӡ󥯤ذư */

		/* եǥ꥿󥯥ݥ󥿤 */
		ck = chunk_open (avi_file->fio);
		/* RIFF󥯤 */
		if (!chunk_in (avi_file->fio, ck))
		  {
			g_free (strn);
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
		/* movi󥯤õ */
		while (chunk_form (avi_file->fio) != CK_LIST_AVIMOVIE)
			if (!chunk_next (avi_file->fio, ck))
			  {
				g_free (strn);
				chunk_free (ck);
				fileio_close (avi_file->fio);
				g_free (ash);
				g_free (avi_file->bmih);
				g_free (avi_file->wfx);
				g_free (avi_file);
				return NULL;
			}
		/* եΥեåȤ */
		offset = fileio_seek (avi_file->fio, 0, FILEIO_SEEK_CUR);
		if (offset == -1)
		  {
			g_free (strn);
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
		offset += sizeof (guint32) + sizeof (guint32);/* moviΥեå */
		/* 󥯥ݥ󥿤 */
		if (!chunk_free (ck))
		  {
			g_free (strn);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }

		/* ǥå󥯤ذư */

		/* եǥ꥿󥯥ݥ󥿤 */
		ck = chunk_open (avi_file->fio);
		/* RIFF󥯤 */
		if (!chunk_in (avi_file->fio, ck))
		  {
			g_free (strn);
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
		/* idx1󥯤õ */
		while (chunk_id (avi_file->fio) != CK_ID_AVINEWINDEX)
			if (!chunk_next (avi_file->fio, ck))
			  {
				g_free (strn);
				chunk_free (ck);
				fileio_close (avi_file->fio);
				g_free (ash);
				g_free (avi_file->bmih);
				g_free (avi_file->wfx);
				g_free (avi_file);
				return NULL;
			}
		/* idx1󥯤Υ */
		/* idx1󥯤(RIFF'AVI ' -> idx1) */
		size = chunk_size (avi_file->fio);
		if (size == -1 || !chunk_in (avi_file->fio, ck))
		  {
			g_free (strn);
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
		/* ǥåɤ߹ */
		for (i = 0; i < size / AIE_SIZE; i++)
		  {
			if (fileio_read (avi_file->fio, &aie, AIE_SIZE) != AIE_SIZE)
			  {
				g_free (strn);
				chunk_free (ck);
				fileio_close (avi_file->fio);
				g_free (ash);
				g_free (avi_file->index);
				g_free (avi_file->bmih);
				g_free (avi_file->wfx);
				g_free (avi_file);
				return NULL;
			  }
			if (((aie_get_ckid (&aie) & 0xff) - '0') * 10
						+ ((aie_get_ckid (&aie) >> 8) & 0xff) - '0' == param)
			  {
				avi_file->index = g_realloc (avi_file->index,
								(avi_file->entries + 1) * sizeof (AviIndex));
				avi_file->index[avi_file->entries].offset
								= aie_get_offset (&aie)
								+ offset + sizeof (guint32) + sizeof(guint32);
				avi_file->index[avi_file->entries].size
													= aie_get_length (&aie);
				avi_file->index[avi_file->entries].flags
													= aie_get_flags (&aie);
				avi_file->entries++;
			  }
		  }
		/* 󥯥ݥ󥿤 */
		if (!chunk_free (ck))
		  {
			g_free (strn);
			fileio_close (avi_file->fio);
			g_free (ash);
			g_free (avi_file->bmih);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
	  }
	/* ǥåȥإå */
	if (ash_get_type (ash) == AVI_STREAM_VIDEO)
	  {
		avi_file->length = avi_file->entries;
	  }
	else
	  {
		avi_file->length = 0;
		for (i = 0; i < avi_file->entries; i++)
			avi_file->length += avi_file->index[i].size
										/ wfx_get_block_align (avi_file->wfx);
	  }
	avi_file->handler = ash_get_handler (ash);
	/*  */
	if (type != NULL)
		*type = ash_get_type (ash);
	if (rate != NULL)
		*rate = ash_get_rate (ash);
	if (scale != NULL)
		*scale = ash_get_scale (ash);
	if (priority != NULL)
		*priority = ash_get_priority (ash);
	if (language != NULL)
		*language = ash_get_language (ash);
	if (name != NULL)
		*name = strn;
	g_free (ash);
	return avi_file;
}


/*	ӥåȥޥåפAVIե빽¤Τ
	file,ե̾
	 RET,AVIե빽¤,NULL:顼										*/
static AviFile *
avi_open_bitmap (const gchar *file)
{
	guint32 size;
	AviFile *avi_file;
	BitmapInfoHeader *bmih0,*bmih1;

	avi_file = g_malloc0 (sizeof (AviFile));
	/* ե򳫤 */
	/* ե򳫤 */
	avi_file->fio = fileio_open (file, FILEIO_ACCESS_READ,
								FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
	if (avi_file->fio == NULL)
	  {
		g_free (avi_file);
		return NULL;
	  }
	/* ˥إåɤ߹ */
	if (fileio_seek(avi_file->fio, BMFH_SIZE, FILEIO_SEEK_SET) == -1)
	  {
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	avi_file->bmih = g_malloc (BMIH_SIZE);
	if (fileio_read (avi_file->fio, avi_file->bmih, BMIH_SIZE) != BMIH_SIZE)
	  {
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	/* إåΥ׻ */
	size = bm_header_bytes (avi_file->bmih);
	/* إåɤ߹ */
	avi_file->bmih = g_realloc (avi_file->bmih, size);
	if (fileio_seek (avi_file->fio, BMFH_SIZE, FILEIO_SEEK_SET) == -1
				|| fileio_read (avi_file->fio, avi_file->bmih, size) != size)
	  {
		fileio_close (avi_file->fio);
		g_free (avi_file->bmih);
		g_free (avi_file);
		return NULL;
	  }
	/* ᡼ɤ߹ */
	if (bmih_get_compression (avi_file->bmih) == BI_COMP_RGB
				|| bmih_get_compression (avi_file->bmih) == BI_COMP_BITFIELDS)
	  {
		/* ̵ */
		size = bm_image_bytes (avi_file->bmih);
		avi_file->data = g_malloc (size);
		if (fileio_read (avi_file->fio, avi_file->data, size) != size)
		  {
			fileio_close (avi_file->fio);
			g_free (avi_file->bmih);
			g_free (avi_file->data);
			g_free (avi_file);
			return NULL;
		  }
	  }
	else if (bmih_get_compression (avi_file->bmih) == BI_COMP_RLE4
					|| bmih_get_compression (avi_file->bmih) == BI_COMP_RLE8)
	  {
		/*  */
		bmih0 = g_malloc (size + bmih_get_size_image (avi_file->bmih));
		g_memmove (bmih0, avi_file->bmih, size);
		if (fileio_read (avi_file->fio, (guint8 *)bmih0 + size,
				bmih_get_size_image (bmih0)) != bmih_get_size_image (bmih0))
		  {
			g_free (bmih0);
			fileio_close (avi_file->fio);
			g_free (avi_file->bmih);
			g_free (avi_file);
			return NULL;
		  }
		bmih1 = g_malloc (bx_all_bytes
							(bmih_get_width (bmih0), bmih_get_height (bmih0),
									bmih_get_bit_count (bmih0), BI_COMP_RGB,
												bmih_get_color_used (bmih0)));
		bitmap_expand (bmih0, bmih1);
		g_free (bmih0);
		/* ŸDIB򥳥ԡ */
		size = bm_header_bytes (bmih1);
		avi_file->bmih = g_realloc (avi_file->bmih, size);
		g_memmove (avi_file->bmih, bmih1, size);
		avi_file->data = g_memdup((guint8 *)bmih1 + size,
											bm_image_bytes (avi_file->bmih));
		g_free (bmih1);
	  }
	else
	  {
		fileio_close (avi_file->fio);
		g_free (avi_file->bmih);
		g_free (avi_file->data);
		g_free (avi_file);
		return NULL;
	  }
	if (!fileio_close (avi_file->fio))
	  {
		g_free (avi_file->bmih);
		g_free (avi_file->data);
		g_free (avi_file);
		return NULL;
	  }
	avi_file->handler = AVI_STREAM_COMP_DIB;
	/* ե */
	avi_file->fio = NULL;				/* եݥ */
	avi_file->length = 1;
	avi_file->entries = 1;				/* ǥåο */
	/* ǥå */
	avi_file->index = g_malloc (sizeof (AviIndex));
	avi_file->index[0].offset = 0;
	avi_file->index[0].size = size;
	avi_file->index[0].flags = 0;
	return avi_file;
}


/*	WAVEե뤫AVIե빽¤Τ
	file,ե̾
	 RET,AVIե빽¤,NULL:顼										*/
static AviFile *
avi_open_wave (const gchar *file)
{
	guint32 size;
	goffset offset;				/* AVIΥࡼӡ */
	AviFile *avi_file;
	Chunk *ck;

	avi_file = g_malloc0 (sizeof (AviFile));
	/* ե򳫤 */
	avi_file->fio = fileio_open (file, FILEIO_ACCESS_READ,
								FILEIO_SHARE_READ, FILEIO_MODE_OPEN_EXISTING);
	if (avi_file->fio == NULL)
	  {
		g_free (avi_file);
		return NULL;
	  }
	/* եǥ꥿󥯥ݥ󥿤 */
	ck = chunk_open (avi_file->fio);
	/* RIFF󥯤 */
	if (!chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	/* fmt󥯤õ */
	while (chunk_id (avi_file->fio) != CK_ID_WAVEFORMAT)
	  {
		if (!chunk_next (avi_file->fio, ck))
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (avi_file);
			return NULL;
		  }
	  }
	/* fmt󥯤Υ */
	/* fmt󥯤(RIFF'AVI ' -> fmt) */
	if ((size = chunk_size(avi_file->fio)) == -1
											|| !chunk_in (avi_file->fio,ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	}
	if (size < WFX_SIZE - sizeof (guint16))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file);
		return NULL;
	  }
	avi_file->wfx = g_malloc (MAX (size, WFX_SIZE));
	wfx_set_size (avi_file->wfx, 0);
	/* WaveFormatExɤ߹ */
	if (fileio_read (avi_file->fio, avi_file->wfx, size) != size)
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }
	/* 󥯥ݥ󥿤 */
	if (!chunk_free (ck))
	  {
		fileio_close (avi_file->fio);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }

	/* եǥ꥿󥯥ݥ󥿤 */
	ck = chunk_open (avi_file->fio);
	/* RIFF󥯤 */
	if (!chunk_in (avi_file->fio,ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }
	/* data󥯤õ */
	while (chunk_id (avi_file->fio) != CK_ID_WAVEDATA)
		if (!chunk_next(avi_file->fio,ck))
		  {
			chunk_free (ck);
			fileio_close (avi_file->fio);
			g_free (avi_file->wfx);
			g_free (avi_file);
			return NULL;
		  }
	/* data󥯤Υ */
	/* data󥯤(RIFF'AVI ' -> data) */
	if ((size = chunk_size (avi_file->fio)) == -1
											|| !chunk_in (avi_file->fio, ck))
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }
	/* եΥեåȤ */
	if ((offset = fileio_seek (avi_file->fio, 0, FILEIO_SEEK_CUR)) == -1)
	  {
		chunk_free (ck);
		fileio_close (avi_file->fio);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }
	/* 󥯥ݥ󥿤 */
	if (!chunk_free (ck))
	  {
		fileio_close (avi_file->fio);
		g_free (avi_file->wfx);
		g_free (avi_file);
		return NULL;
	  }
	/* ե */
	avi_file->length = size / wfx_get_block_align (avi_file->wfx);
	avi_file->entries = 1;				/* ǥåο */
	/* ǥå */
	avi_file->index = g_malloc (sizeof (AviIndex));
	avi_file->index[0].offset = offset;
	avi_file->index[0].size = size;
	avi_file->index[0].flags = 0;
	return avi_file;
}


/*	AVIAVIե빽¤Τ
	    file,ե̾
	   param,ȥ꡼ֹ
	    type,AVI_STREAM_AUDIO/AVI_STREAM_VIDEO
	    rate,졼
	   scale,
	priority,ͥ
	language,
	    name,̾
	     RET,AVIե빽¤,NULL:顼									*/
AviFile *
avi_open_file (const gchar *file, const gint param,
							guint32 *type, guint32 *rate, guint32 *scale,
							guint16 *priority, guint16 *language, gchar **name)
{
	AviFile *avi_file = NULL;

	/* եηʬ */
	switch (avi_file_type (file))
	  {
		case 0:/* AVI */
			avi_file = avi_open_avi (file, param, type, rate, scale,
													priority, language, name);
			break;
		case 1:/* ӥåȥޥå */
			avi_file = param == 0 ? avi_open_bitmap (file) : NULL;
			if (avi_file != NULL)
			  {
				if (type != NULL)
					*type = AVI_STREAM_VIDEO;
				if (rate != NULL)
					*rate = 15;
				if (scale != NULL)
					*scale = 1;
				if (priority != NULL)
					*priority = 0;
				if (language != NULL)
					*language = 0;
				if (name != NULL)
					*name = g_strdup ("Video #1");
			  }
			break;
		case 2:/* WAVEե */
			avi_file = param == 0 ? avi_open_wave (file) : NULL;
			if (avi_file != NULL)
			  {
				if (type != NULL)
					*type = AVI_STREAM_AUDIO;
				if (rate != NULL)
					*rate = wfx_get_average_bytes_per_sec (avi_file->wfx);
				if (scale != NULL)
					*scale = wfx_get_block_align (avi_file->wfx);
				if (priority != NULL)
					*priority = 0;
				if (language != NULL)
					*language = 0;
				if (name != NULL)
					*name = g_strdup ("Audio #1");
			  }
	  }
	if (avi_file != NULL)
	  {
		avi_file->name = fileio_get_full_path (file);	/* ե̾ */
		avi_file->param = param;						/* ȥ꡼ֹ */
	  }
	return avi_file;
}


/*	AVIե빽¤Τ
	avi_file,AVIե빽¤
	     RET,TRUE:ｪλ,FALSE:顼										*/
gboolean
avi_release_file (AviFile *avi_file)
{
	gboolean result;

	result = avi_file->fio == NULL || fileio_close (avi_file->fio);
	g_free (avi_file->name);
	g_free (avi_file->index);
	g_free (avi_file->bmih);
	g_free (avi_file->wfx);
	g_free (avi_file);
	return result;
}


/******************************************************************************
*                                                                             *
* ؿ                                                                  *
*                                                                             *
******************************************************************************/
/*	AVI															*/
gboolean
avi_init (void)
{
	return icm_init ();
}


/*	AVIλ															*/
gboolean
avi_exit (void)
{
	return icm_exit ();
}
