/*
    Video maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __VMAID_H__
#define __VMAID_H__


#include "common.h"
#include "avicore/avicore.h"
#ifdef G_OS_WIN32
# include <tchar.h>
# include <windows.h>
#endif /* G_OS_WIN32 */


#define VMAID_VERSION_NOTICE "Video maid "VERSION" ("VMAID_BUILD_ENVIRONMENT")"
#define VMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2004 Kazuki IWAMOTO"

#define MENUFILE 9


typedef struct VmaidCursor_Tag {
    gint stream;                /* ストリームの位置(0,1) */
    gint frame;                 /* 現在の位置(0...) */
} VmaidCursor;
typedef struct VmaidHistory_Tag {
    AviEdit *avi_edit[2];       /* AVI編集 */
    VmaidCursor cursor,select;
    struct VmaidHistory_Tag *next;
} VmaidHistory;
typedef struct VmaidWindow_Tag {
    gboolean edit;              /* TRUE:編集済み,FALSE:未編集 */
    gchar *file;                /* ファイル名 */
    gint same;                  /* -1:重複なし,0〜:番号 */
    gint top;                   /* ウインドウの先頭 */
    gint width,height;          /* フレームのサイズ */
    guint rate,scale;           /* レート÷スケール=1秒間のフレーム数 */
    guint timer_id;             /* スクロール用タイマ */
    AviEdit *avi_edit[2];       /* AVI編集 */
    VmaidCursor cursor;         /* キャレットの位置 */
    VmaidCursor select;         /* 選択開始位置,-1:選択なし */
    VmaidHistory *undo,*redo;   /* 編集履歴 */
    GtkWidget *drawing;         /* 描画領域 */
    GtkWidget *hscroll;         /* 水平スクロールバー */
    GtkWidget *label;           /* タブのラベル */
    GtkWidget *mark;            /* タブの編集済みマーク */
    GtkWidget *menu_item;       /* メニューのウインドウの項目 */
} VmaidWindow;


enum {
    TARGET_VMAID
};
enum {
    TARGET_STRING
};


extern gboolean caret;                  /* キャレットの形 */
extern gboolean newfile;                /* TRUE:新規ファイル,FALSE:なし */
extern gboolean second;                 /* TRUE:新規,FALSE:既存 */
extern gboolean default_ratio;          /* TRUE:縦/横の比率を保持しない */
extern gboolean file_merge;             /* TRUE:連番,FALSE:単独 */
extern gchar *history_files[10];        /* ファイルの履歴 */
extern gchar *open_path;                /* 開くのパス */
extern gchar *save_path;                /* 名前を付けて保存のパス */
extern gchar *clipboard_scenario;       /* クリップボードのテキスト */
extern gchar *arg_text;                 /* プロセス間通信用変数 */
extern gint def_width,def_height;       /* デフォルトのウインドウのサイズ */
extern gint history;                    /* ファイルの履歴 */
extern gint instance;                   /* プロセス間通信用変数 */
extern gint default_view;               /* ウインドウが作成時の初期値 */
extern guint default_rate;              /* ウインドウが作成時の初期値 */
extern guint timer_id;                  /* タイマID */
extern GdkAtom atom_targets;            /* ターゲット */
extern GdkAtom atom_scenario;           /* シナリオオブジェクト */
extern GdkAtom atom_videomaid0;         /* プロセス間通信用アトム */
extern GdkAtom atom_videomaid1;         /* プロセス間通信用アトム */
extern GdkBitmap *bitmap0;              /* 波背景 */
extern GdkBitmap *bitmap1;              /* 網背景 */
extern GtkWidget *window;               /* ウインドウ */
extern GtkWidget *notebook;             /* ノートブック */
extern GtkWidget *tview;                /* リストボックス */
extern GtkWidget *status;               /* ステータスウインドウ */
extern GtkPositionType n_pos;           /* ノートブックの位置 */
extern GtkItemFactory *ifactory_menu;   /* メニュー */
extern GtkItemFactory *ifactory_popup;  /* ポップアップ */
extern GtkItemFactory *ifactory_tview;  /* ポップアップ */
extern GdkFont *system_font;            /* フォント */
extern gint system_font_height;         /* フォントの高さ */
extern gint system_font_ascent;         /* フォントのアクセントの高さ */
extern GtkListStore *list_store;        /* リスト */
extern GdkColor system_color[4];
#ifdef G_OS_WIN32
extern UINT uFormat;                    /* クリップボード */
#endif /* G_OS_WIN32 */


#endif
