/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __THREAD_H__
#define __THREAD_H__


#include "vmaid.h"
#if defined USE_THREAD && ! defined USE_GTK2
# ifdef HAVE_BITS_SIGSET_H
#   include <bits/sigset.h>
# endif /* HAVE_BITS_SIGSET_H */
# ifdef HAVE_PTHREAD_H
#   include <pthread.h>
# endif /* HAVE_PTHREAD_H */
#endif /* USE_THREAD and not USE_GTK2 */


#define THREAD_MODE_EXIT 0
#define THREAD_MODE_OPEN 1
#define THREAD_MODE_SAVE 2
#define THREAD_MODE_FRAME 3
#define THREAD_MODE_REVERSE 4
#ifndef USE_THREAD
# define THREAD_ID_STANDARD 0
# define THREAD_ID_CLOSE 1
#endif /* not USE_THREAD */


typedef struct ThreadList_Tag {
	gboolean userbreak;	/* TRUE:³,FALSE:׵ */
	gint mode;			/* 0:λ,1:,2:¸,3:ե졼,4:ȿž */
	gint percent;		/* ʹԾ(0...100) */
#ifdef USE_THREAD
# ifdef USE_GTK2
	GThread *id;
# else /* not USE_GTK2 */
	pthread_t id;
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
	gint id;
#endif /* not USE_THREAD */
} ThreadList;


/******************************************************************************
*                                                                             *
* åɴؿ                                                              *
*                                                                             *
******************************************************************************/
/*	ꥹȤ˲ä
	  id,åID
	mode,⡼(0:λ,1:,2:¸,3:ե졼,4:ȿž)
	file,ե̾
	 RET,TRUE:ｪλ,FALSE:顼											*/
#ifdef USE_THREAD
# ifdef USE_GTK2
gboolean
thread_insert (GThread *id, const gint mode, const gchar *file);
# else /* not USE_GTK2 */
gboolean
thread_insert (pthread_t id, const gint mode, const gchar *file);
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
gboolean
thread_insert (gint id, const gint mode, const gchar *file);
#endif /* not USE_THREAD */


/*	ꥹȤ
	 id,åID
	RET,TRUE:ｪλ,FALSE:顼											*/
#ifdef USE_THREAD
# ifdef USE_GTK2
gboolean
thread_delete (GThread *id);
# else /* not USE_GTK2 */
gboolean
thread_delete (pthread_t id);
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
gboolean
thread_delete(gint id);
#endif /* not USE_THREAD */


/*	ꥹȤ򹹿
	     id,åID
	percent,ʹԾ
	    RET,TRUE:³,FALSE:											*/
#ifdef USE_THREAD
# ifdef USE_GTK2
gboolean
thread_idling (GThread *id, const gint percent);
# else /* not USE_GTK2 */
gboolean
thread_idling (pthread_t id, const gint percent);
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
gboolean
thread_idling (gint id, const gint percent);
#endif /* not USE_THREAD */


/*	åɤߤ
	all,TRUE:٤ƤΥå,FALSE:򤵤줿åɤΤ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
thread_break (const gboolean all);


/*	ץνλ(Ωå)											*/
void *
close_program (void);


#endif
