/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "general.h"
#include "thread.h"
#include "toolbar.h"
#include <time.h>


/******************************************************************************
*                                                                             *
* åɴؿ                                                              *
*                                                                             *
******************************************************************************/
#ifdef USE_THREAD
G_LOCK_DEFINE_STATIC (critical);
static volatile gint critical = FALSE;
#else /* not USE_THREAD */
/*	˥塼ꤹ
	task,TRUE:̾,FALSE:λΤ											*/
static void
thread_set_menu_bar (gboolean task)
{
	gint i;
	GList *glist;
	GtkWidget *menu;
	VmaidWindow *vmaid;

	menu = gtk_item_factory_get_widget (item_factory_menu, "<main>/File");
	glist = gtk_container_children (GTK_CONTAINER (menu));
	for (i = g_list_length(glist) - 2; i >= 0; i--)
	  gtk_widget_set_sensitive (GTK_WIDGET (g_list_nth_data (glist, i)), task);
	g_list_free (glist);
	gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
		(gtk_item_factory_get_widget (item_factory_menu, "<main>/Edit"))),
																		task);
	gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
		(gtk_item_factory_get_widget (item_factory_menu, "<main>/View"))),
																		task);
	gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
		(gtk_item_factory_get_widget (item_factory_menu, "<main>/Option"))),
																		task);
	gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
		(gtk_item_factory_get_widget (item_factory_menu, "<main>/Window"))),
																		task);
	gtk_widget_set_sensitive (gtk_menu_get_attach_widget (GTK_MENU
		(gtk_item_factory_get_widget (item_factory_menu, "<main>/Help"))),
																		task);
	for (i = 0; toolbar_items[i].name != (gpointer)-1; i++)
		if (toolbar_items[i].item != NULL)
			gtk_widget_set_sensitive (toolbar_items[i].item, task);
	if (task)
	  {
		glist = gtk_container_children (GTK_CONTAINER (notebook));
		vmaid = g_list_length(glist) > 0 ? gtk_object_get_user_data (GTK_OBJECT
			(gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
			gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook))))) : NULL;
		g_list_free (glist);
		set_menu_bar (vmaid);
	  }
}
#endif /* not USE_THREAD */


/*	ꥹȤ˲ä
	  id,åID
	mode,⡼(0:λ,1:,2:¸,3:ե졼,4:ȿž)
	file,ե̾
	 RET,TRUE:ｪλ,FALSE:顼											*/
#ifdef USE_THREAD
# ifdef USE_GTK2
gboolean
thread_insert (GThread *id, const gint mode, const gchar *file)
# else /* not USE_GTK2 */
gboolean
thread_insert (pthread_t id, const gint mode, const gchar *file)
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
gboolean
thread_insert (gint id, const gint mode, const gchar *file)
#endif /* not USE_THREAD */
{
	gchar *text[4];
	gchar *name[]={N_("Exit"),N_("Open"),N_("Save"),N_("Change Frames"),
																N_("Reverse")};
	time_t tm;
	ThreadList *tl;
#ifdef USE_GTK2
	gint i;
	GtkTreeIter iter;
#endif /* USE_GTK2 */

	tl=g_malloc(sizeof(ThreadList));
	tl->mode=mode;
	tl->percent=0;
	tl->userbreak=TRUE;
	tl->id=id;
	/* ⡼ */
	text[0] = gettext (name[mode]);
	/* ե̾ */
#ifdef USE_GTK2
	text[1] = g_filename_to_utf8 (file != NULL ? file : "", -1,
															NULL, NULL, NULL);
#else /* not USE_GTK2 */
	text[1] = g_strdup (file != NULL ? file : "");
#endif /* not USE_GTK2 */
	/*  */
	tm=time(NULL);
	text[2]=ctime(&tm);
	/* ʹԾ */
	text[3]="0";
	/*  */
#ifdef USE_THREAD
	G_LOCK(critical);
	critical=TRUE;
	gdk_threads_enter();
#endif /* USE_THREAD */
#ifdef USE_GTK2
	gtk_list_store_append (list_store, &iter);
	for (i = 0; i < 4; i++)
		gtk_list_store_set (list_store, &iter, i, text[i], -1);
	gtk_list_store_set (list_store, &iter, 4, tl, -1);
	gtk_tree_view_columns_autosize (GTK_TREE_VIEW (clist));
#else /* USE_GTK2 */
	gtk_clist_set_row_data(GTK_CLIST(clist),
								gtk_clist_append(GTK_CLIST(clist),text),tl);
	gtk_clist_columns_autosize(GTK_CLIST(clist));
#endif /* USE_GTK2 */
#ifdef USE_THREAD
	critical=FALSE;
	gdk_threads_leave();
	G_UNLOCK(critical);
#endif /* USE_THREAD */
	g_free (text[1]);
#ifndef USE_THREAD
	thread_set_menu_bar (FALSE);
	gtk_widget_set_sensitive (notebook, FALSE);
#endif /* not USE_THREAD */
	return TRUE;
}


/*	ꥹȤ
	 id,åID
	RET,TRUE:ｪλ,FALSE:顼											*/
#ifdef USE_THREAD
# ifdef USE_GTK2
gboolean
thread_delete (GThread *id)
# else /* not USE_GTK2 */
gboolean
thread_delete (pthread_t id)
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
gboolean
thread_delete(gint id)
#endif /* not USE_THREAD */
{
	gint i, count;
	ThreadList *tl;
#ifdef USE_GTK2
	GtkTreeIter iter;
#endif /* USE_GTK2 */
#ifndef USE_THREAD
	gint id_standard = 0, id_close = 0;
#endif /* not USE_THREAD */

#ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
	gdk_threads_enter ();
#endif /* USE_THREAD */
#ifdef USE_GTK2
	/* ID˰פ륢ƥõ */
	count = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (list_store), NULL);
	for (i = count - 1; i >= 0; i--)
	  {
		gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_store),
															&iter, NULL, i);
		gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter, 4, &tl, -1);
		if (tl->id == id)
		  {
			/* ꥹȤ˥ƥबȤ */
			g_free (tl);
			gtk_list_store_remove (list_store, &iter);
		  }
	  }
#else /* not USE_GTK2 */
	/* ID˰פ륢ƥõ */
	count = GTK_CLIST(clist)->rows;
	for (i = count - 1; i >= 0; i--)
	  {
		tl = gtk_clist_get_row_data (GTK_CLIST (clist), i);
		if (tl->id == id)
		  {
			/* ꥹȤ˥ƥबȤ */
			g_free (tl);
			gtk_clist_remove (GTK_CLIST (clist), i);
		  }
	  }
#endif /* not USE_GTK2 */
#ifdef USE_THREAD
	gdk_threads_leave ();
	critical = FALSE;
	G_UNLOCK (critical);
#else /* not USE_THREAD */
# ifdef USE_GTK2
	/* ID˰פ륢ƥõ */
	count = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (list_store), NULL);
	for (i = count - 1; i >= 0; i--)
	  {
		gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_store),
															&iter, NULL, i);
		gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter, 4, &tl, -1);
		switch (tl->id)
		  {
			case THREAD_ID_STANDARD: id_standard++; break;
			case THREAD_ID_CLOSE:    id_close++;    break;
		  }
	  }
# else /* not USE_GTK2 */
	/* ID˰פ륢ƥõ */
	count = GTK_CLIST(clist)->rows;
	for (i = count - 1; i >= 0; i--)
	  {
		tl = gtk_clist_get_row_data (GTK_CLIST (clist), i);
		switch (tl->id)
		  {
			case THREAD_ID_STANDARD: id_standard++; break;
			case THREAD_ID_CLOSE:    id_close++;    break;
		  }
	  }
# endif /* not USE_GTK2 */
	if (id_standard <= 0)
	  {
		thread_set_menu_bar (TRUE);
		gtk_widget_set_sensitive (notebook, TRUE);
	  }
	if (id_close > 0)
		gtk_widget_destroy (window);
#endif /* not USE_THREAD */
	return TRUE;
}


/*	ꥹȤ򹹿
	     id,åID
	percent,ʹԾ
	    RET,TRUE:³,FALSE:											*/
#ifdef USE_THREAD
# ifdef USE_GTK2
gboolean
thread_idling (GThread *id, const gint percent)
# else /* not USE_GTK2 */
gboolean
thread_idling (pthread_t id, const gint percent)
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
gboolean
thread_idling (gint id, const gint percent)
#endif /* not USE_THREAD */
{
	gchar *text;
	gint i;
	ThreadList *tl=NULL;
#ifdef USE_GTK2
	GtkTreeIter iter;
#endif /* USE_GTK2 */

#ifdef USE_THREAD
	G_LOCK(critical);
	critical=TRUE;
	gdk_threads_enter();
#endif /* USE_THREAD */
#ifdef USE_GTK2
	/* ID˰פ륢ƥõ */
	for (i = 0; gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_store),
														&iter, NULL, i); i++)
	  {
		gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter, 4, &tl, -1);
		if (tl->id == id)
			break;
	  }
#else /* not USE_GTK2 */
	/* ID˰פ륢ƥõ */
	for (i=0;i<GTK_CLIST(clist)->rows;i++) {
		tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
		if (tl->id==id)
			break;
	}
#endif /* not USE_GTK2 */
	if (tl==NULL) {
#ifdef USE_THREAD
		gdk_threads_leave();
		critical=FALSE;
		G_UNLOCK(critical);
#endif /* USE_THREAD */
		return FALSE;
	}
	if (tl->userbreak && tl->percent!=percent) {
		/* ǤǤϤʤĿʹԾۤʤȤ */
		tl->percent=percent;
		text=percent>=0?g_strdup_printf("%d",percent):g_strdup(_("Error"));
#ifdef USE_GTK2
		gtk_list_store_set (list_store, &iter, 3, text, -1);
#else /* not USE_GTK2 */
		gtk_clist_set_text(GTK_CLIST(clist),i,3,text);
		gtk_clist_set_column_width(GTK_CLIST(clist),3,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),3));
#endif /* not USE_GTK2 */
		g_free(text);
	}
#ifdef USE_THREAD
	critical=FALSE;
	gdk_threads_leave();
	G_UNLOCK(critical);
#else /* not USE_THREAD */
	while (gtk_events_pending ())
		gtk_main_iteration ();
#endif /* not USE_THREAD */
	return tl->userbreak;
}


/*	åɤߤ
	all,TRUE:٤ƤΥå,FALSE:򤵤줿åɤΤ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
thread_break (const gboolean all)
{
	gint i;
	ThreadList *tl;
#ifdef USE_GTK2
	GtkTreeIter iter;
	GtkTreeSelection *select;
#endif /* USE_GTK2 */

#ifdef USE_THREAD
	G_LOCK (critical);
	critical = TRUE;
	gdk_threads_enter ();
#endif /* USE_THREAD */
#ifdef USE_GTK2
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (clist));
	for (i = 0; gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_store),
														&iter, NULL, i); i++)
		if (all || gtk_tree_selection_iter_is_selected (select, &iter))
		  {
			gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter,
																4, &tl, -1);
			if (tl->userbreak)
			  {
				tl->userbreak = FALSE;
				gtk_list_store_set (list_store, &iter, 3, "*", -1);
			  }
		  }
#else /* not USE_GTK2 */
	for (i=0;i<GTK_CLIST(clist)->rows;i++)
		if (all || ((GtkCListRow *)
					(g_list_nth(GTK_CLIST(clist)->row_list,i)->data))->state
														==GTK_STATE_SELECTED) {
			tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
			if (tl->userbreak) {
				/* ɽѹ */
				tl->userbreak=FALSE;
				gtk_clist_set_text(GTK_CLIST(clist),i,3,"*");
				gtk_clist_set_column_width(GTK_CLIST(clist),3,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),3));
			}
		}
#endif /* not USE_GTK2 */
#ifdef USE_THREAD
	gdk_threads_leave ();
	critical = FALSE;
	G_UNLOCK (critical);
#endif /* USE_THREAD */
	return TRUE;
}


/*	ץνλ(Ωå)											*/
void *
close_program (void)
{
	gboolean result;
	gint i,count,length;
	GList *glist;
	ThreadList *tl;
#ifdef USE_GTK2
	GtkTreeIter iter;
#endif /* USE_GTK2 */
#ifdef USE_THREAD
# ifdef USE_GTK2
	GThread *id;

	id=g_thread_self();
# else /* not USE_GTK2 */
	pthread_t id;

	id=pthread_self();
# endif /* not USE_GTK2 */
#else /* not USE_THREAD */
	gint id = 1;
#endif /* not USE_THREAD */

#ifdef USE_THREAD
	thread_insert(id,THREAD_MODE_EXIT,NULL);

	/* ˥顼ˤʤäƤ륹åɤλ */
	G_LOCK(critical);
	critical=TRUE;
	gdk_threads_enter();
#endif /* USE_THREAD */

	/* 顼ˤʤäƤ륢ƥõ */
#ifdef USE_GTK2
	for (i = 0; gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_store),
														&iter, NULL, i); i++)
	  {
		gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter, 4, &tl, -1);
		if (tl->percent < 0 && tl->userbreak) /* ꥹȤ˥ƥबȤ */
		  {
			/* ɽѹ */
			tl->userbreak = FALSE;
			gtk_list_store_set (list_store, &iter, 3, "*", -1);
		  }
	  }
#else /* not USE_GTK2 */
	for (i=GTK_CLIST(clist)->rows-1;i>=0;i--) {
		tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
		if (tl->percent<0 && tl->userbreak) { /* ꥹȤ˥ƥबȤ */
			/* ɽѹ */
			tl->userbreak=FALSE;
			gtk_clist_set_text(GTK_CLIST(clist),i,3,"*");
			gtk_clist_set_column_width(GTK_CLIST(clist),3,
						gtk_clist_optimal_column_width(GTK_CLIST(clist),3));
		}
	}
#endif /* not USE_GTK2 */

#ifdef USE_THREAD
	gdk_threads_leave();
	critical=FALSE;
	G_UNLOCK(critical);

	do {
# ifdef USE_GTK2
		g_thread_yield();
# endif /* USE_GTK2 */
		G_LOCK(critical);
		critical=TRUE;
		gdk_threads_enter();
#endif /* USE_THREAD */

		/* λåɤ˰פ륢ƥõ */
		result = FALSE;
#ifdef USE_GTK2
		count = gtk_tree_model_iter_n_children (GTK_TREE_MODEL (list_store),
																		NULL);
		for (i = count - 1; i >= 0; i--)
		  {
			gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (list_store), &iter,
																	NULL, i);
			gtk_tree_model_get (GTK_TREE_MODEL (list_store), &iter,
																4, &tl, -1);
			if (tl->mode == THREAD_MODE_EXIT)
			  {
				/* ꥹȤ˥ƥबȤ */
				result = tl->id != id;
				break;
			  }
		  }
#else /* not USE_GTK2 */
		count=GTK_CLIST(clist)->rows;
		for (i=count-1;i>=0;i--) {
			tl=gtk_clist_get_row_data(GTK_CLIST(clist),i);
			if (tl->mode==THREAD_MODE_EXIT) {
				/* ꥹȤ˥ƥबȤ */
				result=tl->id!=id;
				break;
			}
		}
#endif /* not USE_GTK2 */
		/* Ρȥ֥åλҥɥ */
		glist=gtk_container_children(GTK_CONTAINER(notebook));
		length=g_list_length(glist);
		g_list_free(glist);

#ifdef USE_THREAD
		gdk_threads_leave();
		critical=FALSE;
		G_UNLOCK(critical);

		/* ꥹȤ˽λꡢΥåɰʳʤФΥåɤ˴ */
		if (result || !thread_idling(id,0)) {
			thread_delete(id);
			return NULL;
		}
	} while (count>1 || length>0);
	thread_delete(id);
	gdk_threads_enter();
	gtk_widget_destroy(window);
	gdk_threads_leave();
#else /* not USE_THREAD */
	/* λ */
	if (length <= 0)
	  {
		if (count <= 0)
			gtk_widget_destroy (window);
		else if (i < 0)
			thread_insert (THREAD_ID_CLOSE, THREAD_MODE_EXIT, NULL);
	  }
#endif /* USE_THREAD */
	return NULL;
}
