/*
    Video maid
    copyright (c) 1998-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __SIGMAIN_H__
#define __SIGMAIN_H__


#include "vmaid.h"


/******************************************************************************
*                                                                             *
* VOi/Cxg֐Q(eLXg)                                           *
*                                                                             *
******************************************************************************/
void signal_style_set(GtkWidget *widget,GtkStyle *style,gpointer user_data);


/******************************************************************************
*                                                                             *
* VOi/Cxg֐Q(j[)                                           *
*                                                                             *
******************************************************************************/
void signal_activate_menu_window(GtkWidget *widget,GtkWidget *child);
void signal_activate_menu_history(GtkWidget *widget,gchar *file);
void signal_destroy_menu_history(GtkWidget *widget,gchar *file);


/******************************************************************************
*                                                                             *
* VOi/Cxg֐Q(m[g)                                             *
*                                                                             *
******************************************************************************/
void signal_clicked(GtkWidget *widget,GtkWidget *child);
void signal_switch_page(GtkNotebook *notebook,GtkNotebookPage *page,
											gint page_num,gpointer user_data);
void signal_destroy_notebook(GtkWidget *widget,gpointer user_data);


/******************************************************************************
*                                                                             *
* VOi/Cxg֐Q(Xg)                                             *
*                                                                             *
******************************************************************************/
#ifdef USE_GTK2
void
signal_changed (GtkTreeSelection *select, gpointer user_data);
#else /* not USE_GTK2 */
void signal_select_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data);
void signal_unselect_row(GtkWidget *widget,gint row,gint column,
									GdkEventButton *event,gpointer user_data);
gboolean signal_button_press_clist(GtkWidget *widget,GdkEventButton *event,
														gpointer user_data);
#endif /* not USE_GTK2 */


/******************************************************************************
*                                                                             *
* VOi/Cxg֐Q(ZNV)                                       *
*                                                                             *
******************************************************************************/
void signal_drag_data_received(GtkWidget *widget,GdkDragContext *context,
		gint x,gint y,GtkSelectionData *selection_data,guint info,guint time);
gboolean signal_selection_clear(GtkWidget *widget,GdkEventSelection *event,
														gpointer user_data);
void signal_selection_get(GtkWidget *widget,GtkSelectionData *data,
									guint info,guint time,gpointer user_data);
void signal_selection_received(GtkWidget *widget,GtkSelectionData *data,
												guint time,gpointer user_data);


/******************************************************************************
*                                                                             *
* VOi/Cxg֐Q(C)                                             *
*                                                                             *
******************************************************************************/
gboolean signal_delete(GtkWidget *widget,GdkEvent *event,gpointer user_data);
void signal_destroy_window(GtkWidget *widget,gpointer user_data);


#endif
