/*
    avicore
    copyright (c) 2002-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* Chunk                                                                       *
*                                                                             *
******************************************************************************/
#include "chunk.h"


/*	󥯹¤Τ
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean chunk_free(Chunk *ck)
{
	if (ck==NULL)
		return FALSE;
	g_free(ck->list);
	g_free(ck);
	return TRUE;
}


/*	󥯤
	fio,եݥ
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
chunk_in (FileIO *fio, Chunk *ck)
{
	if (ck == NULL || (ck->num > 0
				&& GUINT32_FROM_LE (ck->list[ck->num - 1].id) != CK_DEF_RIFF
				&& GUINT32_FROM_LE (ck->list[ck->num - 1].id) != CK_DEF_LIST))
		return FALSE;
	ck->list = g_realloc (ck->list, (ck->num + 1) * sizeof (ChunkList));
	if ((ck->list[ck->num].offset = fileio_seek (fio, 0, FILEIO_SEEK_CUR))
																		== -1
		|| fileio_read (fio, &ck->list[ck->num].id, sizeof (guint32))
															!= sizeof (guint32)
		|| fileio_read (fio, &ck->list[ck->num].size, sizeof (guint32))
															!= sizeof (guint32)
		|| ((GUINT32_FROM_LE (ck->list[ck->num].id) == CK_DEF_RIFF
				|| GUINT32_FROM_LE (ck->list[ck->num].id) == CK_DEF_LIST)
				&& fileio_read (fio, &ck->list[ck->num].form, sizeof (guint32))
														!= sizeof (guint32)))
	  {
		fileio_seek (fio, ck->list[ck->num].offset, FILEIO_SEEK_SET);
		return FALSE;
	  }
	ck->list[ck->num].size = GUINT32_FROM_LE (ck->list[ck->num].size);
	ck->num++;
	return TRUE;
}


/*	󥯤Ф
	fio,եݥ
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
chunk_out (FileIO *fio, Chunk *ck)
{
	if (ck == NULL || ck->num <= 0)
		return FALSE;
	ck->num--;
	fileio_seek (fio, ck->list[ck->num].offset, FILEIO_SEEK_SET);
	ck->list = g_realloc (ck->list, ck->num * sizeof (ChunkList));
	return TRUE;
}


/*	Υ󥯤˰ư
	fio,եݥ
	 ck,󥯹¤
	RET,TRUE:ｪλ,FALSE:顼											*/
gboolean
chunk_next (FileIO *fio, Chunk *ck)
{
	guint32 size;
	goffset offset;

	offset = fileio_seek (fio, 0, FILEIO_SEEK_CUR);
	if (ck == NULL
			|| fileio_seek (fio, sizeof (guint32), FILEIO_SEEK_CUR) == -1
			|| fileio_read (fio, &size, sizeof (guint32)) != sizeof (guint32))
	  {
		fileio_seek (fio, offset, FILEIO_SEEK_SET);
		return FALSE;
	  }
	size = (GUINT32_FROM_LE (size) + 1) & ~1;
	if ((ck->num > 0
				&& ck->list[ck->num - 1].offset + ck->list[ck->num - 1].size
															<= offset + size)
							|| fileio_seek (fio, size, FILEIO_SEEK_CUR) == -1)
	  {
		fileio_seek (fio, offset, FILEIO_SEEK_SET);
		return FALSE;
	  }
	return TRUE;
}


/*	󥯤ID
	fio,եݥ
	RET,ID,-1:顼														*/
guint32
chunk_id (FileIO *fio)
{
	guint32 id;

	return fileio_read (fio, &id, sizeof (guint32)) == sizeof (guint32)
		&& fileio_seek (fio, -(gint)sizeof (guint32), FILEIO_SEEK_CUR) != -1
										? GUINT32_FROM_LE (id) : (guint32) -1;

}


/*	󥯤Υ
	fio,եݥ
	RET,,-1:顼													*/
guint32
chunk_size (FileIO *fio)
{
	guint32 size;

	return fileio_seek(fio, sizeof (guint32), FILEIO_SEEK_CUR) != -1
		&& fileio_read (fio, &size, sizeof (guint32)) == sizeof (guint32)
		&& fileio_seek (fio, -(gint)(sizeof (guint32) * 2), FILEIO_SEEK_CUR)
								!= -1 ? GUINT32_FROM_LE (size) : (guint32)-1;
}


/*	󥯤Υե
	fio,եݥ
	RET,ե,-1:顼													*/
guint32
chunk_form (FileIO *fio)
{
	guint32 id, form;

	return fileio_read (fio, &id, sizeof (guint32)) == sizeof (guint32)
		&& fileio_seek (fio, sizeof(guint32), FILEIO_SEEK_CUR) != -1
		&& fileio_read (fio, &form, sizeof (guint32)) == sizeof (guint32)
		&& fileio_seek (fio, -(gint)(sizeof (guint32) * 3), FILEIO_SEEK_CUR)
																		!= -1
		&& (GUINT32_FROM_LE (id) == CK_DEF_RIFF
										|| GUINT32_FROM_LE (id) == CK_DEF_LIST)
										? GUINT32_FROM_LE (form) : (guint32)-1;
}
