/*
    avicore
    copyright (c) 1999-2003 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/******************************************************************************
*                                                                             *
* ӥåȥޥå                                                                *
*                                                                             *
******************************************************************************/
#ifndef __BITMAP_H__
#define __BITMAP_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif


#define BI_COMP_RGB			0
#define BI_COMP_RLE8		1
#define BI_COMP_RLE4		2
#define BI_COMP_BITFIELDS	3


#define BMFH_SIZE 14
#define BMIH_SIZE 40
#define RGBQUAD_SIZE 4


#ifdef USE_GCC


typedef struct BitmapFileHeader_Tag {
	guint16 type __attribute__((packed));
	guint32 size __attribute__((packed));
	guint16 reserved1 __attribute__((packed));
	guint16 reserved2 __attribute__((packed));
	guint32 off_bits __attribute__((packed));
} BitmapFileHeader;


typedef struct BitmapInfoHeader_Tag {
	guint32 size __attribute__((packed));
	gint32 width __attribute__((packed));
	gint32 height __attribute__((packed));
	guint16 planes __attribute__((packed));
	guint16 bit_count __attribute__((packed));
	guint32 compression __attribute__((packed));
	guint32 size_image __attribute__((packed));
	gint32 x_pixels_per_meter __attribute__((packed));
	gint32 y_pixels_per_meter __attribute__((packed));
	guint32 color_used __attribute__((packed));
	guint32 color_important __attribute__((packed));
} BitmapInfoHeader;


typedef struct RgbQuad_Tag {
	guint8 blue __attribute__((packed));
	guint8 green __attribute__((packed));
	guint8 red __attribute__((packed));
	guint8 reserved __attribute__((packed));
} RgbQuad;


#else


typedef struct { guint8 dummy[BMFH_SIZE]; } BitmapFileHeader;
typedef struct { guint8 dummy[BMIH_SIZE]; } BitmapInfoHeader;
typedef struct { guint8 dummy[RGBQUAD_SIZE]; } RgbQuad;


#endif


/******************************************************************************
*                                                                             *
* ¤Υޥ                                                                *
*                                                                             *
******************************************************************************/
#define bmfh_get_type(bmfh) GUINT16_FROM_LE(*(guint16 *)(bmfh))
#define bmfh_get_size(bmfh) GUINT32_FROM_LE(*(guint32 *)((guint8 *)(bmfh)+2))
#define bmfh_get_off_bits(bmfh)												\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(bmfh)+10))
#define bmfh_set_type(bmfh,type) (*(guint16 *)(bmfh)=GUINT16_TO_LE(type))
#define bmfh_set_size(bmfh,size)											\
						(*(guint32 *)((guint8 *)(bmfh)+2)=GUINT32_TO_LE(size))
#define bmfh_set_off_bits(bmfh,off_bits)									\
					(*(guint32 *)((guint8 *)(bmfh)+10)=GUINT32_TO_LE(off_bits))


#define bmih_get_size(bmih) GUINT32_FROM_LE(*(guint32 *)(bmih))
#define bmih_get_width(bmih) GINT32_FROM_LE(*(gint32 *)((guint8 *)(bmih)+4))
#define bmih_get_height(bmih) GINT32_FROM_LE(*(gint32 *)((guint8 *)(bmih)+8))
#define bmih_get_planes(bmih)												\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(bmih)+12))
#define bmih_get_bit_count(bmih)											\
							GUINT16_FROM_LE(*(guint16 *)((guint8 *)(bmih)+14))
#define bmih_get_compression(bmih)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(bmih)+16))
#define bmih_get_size_image(bmih)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(bmih)+20))
#define bmih_get_x_pixels_per_meter(bmih)									\
							GINT32_FROM_LE(*(gint32 *)((guint8 *)(bmih)+24))
#define bmih_get_y_pixels_per_meter(bmih)									\
							GINT32_FROM_LE(*(gint32 *)((guint8 *)(bmih)+28))
#define bmih_get_color_used(bmih)											\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(bmih)+32))
#define bmih_get_color_important(bmih)										\
							GUINT32_FROM_LE(*(guint32 *)((guint8 *)(bmih)+36))
#define bmih_set_size(bmih,size) (*(guint32 *)(bmih)=GUINT32_TO_LE(size))
#define bmih_set_width(bmih,width)											\
						(*(gint32 *)((guint8 *)(bmih)+4)=GINT32_TO_LE(width))
#define bmih_set_height(bmih,height)										\
						(*(gint32 *)((guint8 *)(bmih)+8)=GINT32_TO_LE(height))
#define bmih_set_planes(bmih,planes)										\
					(*(guint16 *)((guint8 *)(bmih)+12)=GUINT16_TO_LE(planes))
#define bmih_set_bit_count(bmih,bit_count)									\
				(*(guint16 *)((guint8 *)(bmih)+14)=GUINT16_TO_LE(bit_count))
#define bmih_set_compression(bmih,compression)								\
				(*(guint32 *)((guint8 *)(bmih)+16)=GUINT32_TO_LE(compression))
#define bmih_set_size_image(bmih,size_image)								\
				(*(guint32 *)((guint8 *)(bmih)+20)=GUINT32_TO_LE(size_image))
#define bmih_set_x_pixels_per_meter(bmih,x_pixels_per_meter)				\
			(*(gint32 *)((guint8 *)(bmih)+24)=GINT32_TO_LE(x_pixels_per_meter))
#define bmih_set_y_pixels_per_meter(bmih,y_pixels_per_meter)				\
			(*(gint32 *)((guint8 *)(bmih)+28)=GINT32_TO_LE(y_pixels_per_meter))
#define bmih_set_color_used(bmih,color_used)								\
				(*(guint32 *)((guint8 *)(bmih)+32)=GUINT32_TO_LE(color_used))
#define bmih_set_color_important(bmih,color_important)						\
			(*(guint32 *)((guint8 *)(bmih)+36)=GUINT32_TO_LE(color_important))


#define RGB_BLUE 0
#define RGB_GREEN 1
#define RGB_RED 2
#define RGB_RESERVED 3
#define rgbquad_get(rgb,index,color) (*((guint8 *)(rgb)+(index)*4+(color)))
#define rgbquad_set(rgb,index,color,value)									\
								(*((guint8 *)(rgb)+(index)*4+(color))=(value))
#define rgbquad_set_all(rgb,index,blue,green,red,reserved) (				\
						*((guint8 *)(rgb)+(index)*4+RGB_BLUE)=(blue),		\
						*((guint8 *)(rgb)+(index)*4+RGB_GREEN)=(green),		\
						*((guint8 *)(rgb)+(index)*4+RGB_RED)=(red),			\
						*((guint8 *)(rgb)+(index)*4+RGB_RESERVED)=(reserved))
#define rgb_get(bmih,index,color)											\
							rgbquad_get((guint8 *)(bmih)+BMIH_SIZE,index,color)
#define rgb_set(bmih,index,color,value)										\
					rgbquad_set((guint8 *)(bmih)+BMIH_SIZE,index,color,value)
#define rgb_set_all(bmih,index,blue,green,red,reserved) (					\
					rgbquad_set_all((guint8 *)(bmih)+BMIH_SIZE,index,color,	\
													blue,green,red,reserved)


/******************************************************************************
*                                                                             *
* ӥåȥޥåץޥ                                                          *
*                                                                             *
******************************************************************************/
/*	RgbQuad¤Το
	      width,
	     height,⤵
	  bit_count,1ԥ뤢Υӥåȿ
	compression,̷
	 color_used,
	        RET,RgbQuad¤Το											*/
#define bx_color_used(width,height,bit_count,compression,color_used)		\
				((color_used)>0?(color_used):((bit_count)<=8?1<<(bit_count):0))


/*	RgbQuad¤Τޤguint32ΥХȿ
	      width,
	     height,⤵
	  bit_count,1ԥ뤢Υӥåȿ
	compression,̷
	 color_used,
	        RET,Хȿ													*/
#define bx_color_bytes(width,height,bit_count,compression,color_used)		\
			((compression)!=BI_COMP_BITFIELDS								\
			?bx_color_used(width,height,bit_count,compression,color_used)	\
											*RGBQUAD_SIZE:sizeof(guint32)*3)


/*	BitmapInfoHeader¤ΤRgbQuad¤Τޤguint32ΥХȿ
	      width,
	     height,⤵
	  bit_count,1ԥ뤢Υӥåȿ
	compression,̷
	 color_used,
	        RET,Хȿ													*/
#define bx_header_bytes(width,height,bit_count,compression,color_used)		\
	(bx_color_bytes(width,height,bit_count,compression,color_used)+BMIH_SIZE)


/*	1饤ΥХȿ
	      width,
	     height,⤵
	  bit_count,1ԥ뤢Υӥåȿ
	compression,̷
	 color_used,
	        RET,Хȿ													*/
#define bx_line_bytes(width,height,bit_count,compression,color_used)		\
											((((width)*(bit_count)+31)&~31)/8)


/*	ԥǡΥХȿ
	      width,
	     height,⤵
	  bit_count,1ԥ뤢Υӥåȿ
	compression,̷
	 color_used,
	        RET,Хȿ													*/
#define bx_image_bytes(width,height,bit_count,compression,color_used)		\
	(bx_line_bytes(width,height,bit_count,compression,color_used)*(height)) \


/*	ӥåȥޥåפΥХȿ
	      width,
	     height,⤵
	  bit_count,1ԥ뤢Υӥåȿ
	compression,̷
	 color_used,
	        RET,Хȿ													*/
#define bx_all_bytes(width,height,bit_count,compression,color_used)			\
			(bx_header_bytes(width,height,bit_count,compression,color_used)	\
			+bx_image_bytes(width,height,bit_count,compression,color_used))


/*	RgbQuad¤Το
	bmih,BitmapInfoHeader¤ΤؤΥݥ
	 RET,RgbQuad¤Το													*/
#define bm_color_used(bmih) bx_color_used(bmih_get_width(bmih),				\
						bmih_get_height(bmih),bmih_get_bit_count(bmih),		\
						bmih_get_compression(bmih),bmih_get_color_used(bmih))


/*	RgbQuad¤Τޤguint32ΥХȿ
	bmih,BitmapInfoHeader¤ΤؤΥݥ
	 RET,Хȿ															*/
#define bm_color_bytes(bmih) bx_color_bytes(bmih_get_width(bmih),			\
						bmih_get_height(bmih),bmih_get_bit_count(bmih),		\
						bmih_get_compression(bmih),bmih_get_color_used(bmih))


/*	BitmapInfoHeader¤ΤRgbQuad¤Τޤguint32ΥХȿ
	bmih,BitmapInfoHeader¤ΤؤΥݥ
	 RET,Хȿ															*/
#define bm_header_bytes(bmih)												\
				bx_header_bytes(bmih_get_width(bmih),bmih_get_height(bmih),	\
						bmih_get_bit_count(bmih),bmih_get_compression(bmih),\
													bmih_get_color_used(bmih))


/*	1饤ΥХȿ
	bmih,BitmapInfoHeader¤ΤؤΥݥ
	 RET,Хȿ															*/
#define bm_line_bytes(bmih) bx_line_bytes(bmih_get_width(bmih),				\
						bmih_get_height(bmih),bmih_get_bit_count(bmih),		\
						bmih_get_compression(bmih),bmih_get_color_used(bmih))


/*	ԥǡΥХȿ
	bmih,BitmapInfoHeader¤ΤؤΥݥ
	 RET,Хȿ															*/
#define bm_image_bytes(bmih) bx_image_bytes(bmih_get_width(bmih),			\
						bmih_get_height(bmih),bmih_get_bit_count(bmih),		\
						bmih_get_compression(bmih),bmih_get_color_used(bmih))


/*	ӥåȥޥåפΥХȿ
	bmih,BitmapInfoHeader¤ΤؤΥݥ
	 RET,Хȿ															*/
#define bm_all_bytes(bmih) (bm_header_bytes(bmih)+bm_image_bytes(bmih))


/******************************************************************************
*                                                                             *
* ӥåȥޥåײùؿ                                                        *
*                                                                             *
******************************************************************************/
/*	ǤդΥѥåȤ
	count,ѥåȤ
	  rgb,ѥåȤǼХåե
	table,ѥåʬΩ												*/
void bitmap_make_palette(const gint count,RgbQuad *rgb,
													guint table[32][32][32]);


/*	̤줿ӥåȥޥåפ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_expand(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ1ӥåȥӥåȥޥåפѴ()
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_approx_1(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ4ӥåȥӥåȥޥåפѴ()
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_approx_4(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ8ӥåȥӥåȥޥåפѴ()
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_approx_8(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ1ӥåȥӥåȥޥåפѴ(Ȼ)
	pbmih0,ΥӥåȥޥåפؤΥݥ
	pbmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_diffuse_1(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ4ӥåȥӥåȥޥåפѴ(Ȼ)
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_diffuse_4(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ8ӥåȥӥåȥޥåפѴ(Ȼ)
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_diffuse_8(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ1ӥåȥӥåȥޥåפѴ()
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_order_1(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ4ӥåȥӥåȥޥåפѴ()
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_order_4(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ8ӥåȥӥåȥޥåפѴ()
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_order_8(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼/32ӥåȥӥåȥޥåפ16ӥåȥӥåȥޥåפѴ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_convert_16(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ӥåȥޥåפե륫顼ӥåȥޥåפѴ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_convert_24(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	32ӥåȥӥåȥޥåפե륫顼ӥåȥޥåפѴ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ
	  rgb,طʿ															*/
void bitmap_convert_24_with_bgcolor(BitmapInfoHeader *bmih0,
										BitmapInfoHeader *bmih1,RgbQuad *rgb);


/*	ӥåȥޥåפ32ӥåȥӥåȥޥåפѴ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_convert_32(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	1ӥåȥӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom_1(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	4ӥåȥӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom_4(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	8ӥåȥӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom_8(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	16ӥåȥӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom_16(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ե륫顼ӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom_24(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	32ӥåȥӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom_32(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	ӥåȥޥåפΥѹ
	bmih0,ΥӥåȥޥåפؤΥݥ
	bmih1,ӥåȥޥåפؤΥݥ									*/
void bitmap_zoom(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1);


/*	32ӥåȥӥåȥޥåפŤ͹碌
	    bmih0,ˤʤӥåȥޥåפؤΥݥ
	    bmih1,ˤʤӥåȥޥåפؤΥݥ
	x_overlay,Xɸ
	y_overlay,Xɸ
	    trans,Ʃῧ,TRUE:ͭ,FALSE:̵									*/
void bitmap_overlay_32(BitmapInfoHeader *bmih0,BitmapInfoHeader *bmih1,
								gint x_overlay,gint y_overlay,gboolean trans);


#ifdef __cplusplus
}
#endif
#endif
